/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.ConflictException;
import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import io.crate.rest.action.HttpErrorStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;

public final class RelationAlreadyExists
extends ElasticsearchException
implements ConflictException,
TableScopeException {
    private static final String MESSAGE_TMPL = "Relation '%s' already exists.";
    private RelationName relationName;

    public RelationAlreadyExists(RelationName relationName) {
        super(String.format(Locale.ENGLISH, MESSAGE_TMPL, relationName), new Object[0]);
        this.relationName = relationName;
    }

    public RelationAlreadyExists(RelationName relationName, String message) {
        super(message, new Object[0]);
        this.relationName = relationName;
    }

    RelationAlreadyExists(Index index, Throwable e) {
        super(String.format(Locale.ENGLISH, MESSAGE_TMPL, index.getName()), e, new Object[0]);
        this.relationName = RelationName.fromIndexName(index.getName());
    }

    public RelationAlreadyExists(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return Collections.singletonList(this.relationName);
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.RELATION_WITH_THE_SAME_NAME_EXISTS_ALREADY;
    }
}

