/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.auth.AccessControl;
import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.CrateException;
import io.crate.exceptions.DuplicateKeyException;
import io.crate.exceptions.InvalidRelationName;
import io.crate.exceptions.JobKilledException;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.SQLParseException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.metadata.PartitionName;
import io.crate.sql.parser.ParsingException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NoSeedNodeLeftException;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.RemoteTransportException;
import org.jetbrains.annotations.Nullable;

public class SQLExceptions {
    private static final Logger LOGGER = LogManager.getLogger(SQLExceptions.class);
    private static final Predicate<Throwable> EXCEPTIONS_TO_UNWRAP = throwable -> throwable instanceof RemoteTransportException || throwable instanceof CompletionException || throwable instanceof UncategorizedExecutionException || throwable instanceof ElasticsearchWrapperException || throwable instanceof ExecutionException || throwable instanceof NotSerializableExceptionWrapper || throwable.getClass() == RuntimeException.class;
    private static final List<Class<? extends IOException>> CORRUPTION_EXCEPTIONS = List.of(CorruptIndexException.class, IndexFormatTooOldException.class, IndexFormatTooNewException.class);

    public static Throwable unwrap(Throwable t) {
        int counter = 0;
        Throwable result = t;
        while (EXCEPTIONS_TO_UNWRAP.test(result)) {
            Throwable cause = result.getCause();
            if (cause == null) {
                return result;
            }
            if (cause == result) {
                return result;
            }
            if (counter > 10) {
                LOGGER.warn("Exception cause unwrapping ran for 10 levels. Aborting unwrap", t);
                return result;
            }
            ++counter;
            result = cause;
        }
        return result;
    }

    public static RestStatus status(Throwable t) {
        if (t != null) {
            if (t instanceof ElasticsearchException) {
                return ((ElasticsearchException)t).status();
            }
            if (t instanceof IllegalArgumentException) {
                return RestStatus.BAD_REQUEST;
            }
            if (t instanceof EsRejectedExecutionException) {
                return RestStatus.TOO_MANY_REQUESTS;
            }
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public static <T extends Throwable> void maybeThrowRuntimeAndSuppress(List<T> exceptions) {
        Throwable main = Exceptions.merge(exceptions);
        if (main != null) {
            throw new ElasticsearchException(main);
        }
    }

    public static IOException unwrapCorruption(Throwable t) {
        return t == null ? null : (IOException)Exceptions.firstCauseOrSuppressed((Throwable)t, cause -> {
            for (Class<? extends IOException> clazz : CORRUPTION_EXCEPTIONS) {
                if (!clazz.isInstance(cause)) continue;
                return true;
            }
            return false;
        }).orElse(null);
    }

    public static String messageOf(@Nullable Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        Throwable unwrappedT = SQLExceptions.unwrap(t);
        if (unwrappedT.getMessage() == null) {
            StackTraceElement[] stackTraceElements;
            if (unwrappedT instanceof CrateException && unwrappedT.getCause() != null) {
                unwrappedT = unwrappedT.getCause();
            }
            if ((stackTraceElements = unwrappedT.getStackTrace()).length > 0) {
                return String.format(Locale.ENGLISH, "%s in %s", unwrappedT.getClass().getSimpleName(), stackTraceElements[0]);
            }
            return "Error in " + unwrappedT.getClass().getSimpleName();
        }
        return unwrappedT.getMessage();
    }

    public static boolean isShardNotAvailable(Throwable e) {
        Throwable actual = SQLExceptions.unwrap(e);
        return actual instanceof ShardNotFoundException || actual instanceof IndexNotFoundException || actual instanceof IllegalIndexShardStateException || actual instanceof NoShardAvailableActionException || actual instanceof UnavailableShardsException || actual instanceof AlreadyClosedException;
    }

    public static boolean maybeTemporary(Throwable t) {
        return t instanceof NodeNotConnectedException || t instanceof NodeClosedException || t instanceof NodeDisconnectedException || t instanceof ConnectTransportException || t instanceof ConnectException || t instanceof ClusterBlockException || t instanceof NoSeedNodeLeftException || t instanceof IndexNotFoundException || t instanceof NoShardAvailableActionException || t instanceof UnavailableShardsException || t instanceof AlreadyClosedException || t instanceof ElasticsearchTimeoutException;
    }

    public static Throwable prepareForClientTransmission(AccessControl accessControl, Throwable e) {
        Throwable unwrappedError = SQLExceptions.unwrap(e);
        e = SQLExceptions.esToCrateException(unwrappedError);
        try {
            accessControl.ensureMaySee(e);
        }
        catch (Exception mpe) {
            e = mpe;
        }
        return e;
    }

    private static Throwable esToCrateException(Throwable unwrappedError) {
        if (unwrappedError instanceof IllegalArgumentException || unwrappedError instanceof ParsingException) {
            return new SQLParseException(unwrappedError.getMessage(), (Exception)unwrappedError);
        }
        if (unwrappedError instanceof UnsupportedOperationException) {
            return new UnsupportedFeatureException(unwrappedError.getMessage(), (Exception)unwrappedError);
        }
        if (SQLExceptions.isDocumentAlreadyExistsException(unwrappedError)) {
            return new DuplicateKeyException(((EngineException)unwrappedError).getIndex().getName(), "A document with the same primary key exists already", unwrappedError);
        }
        if (unwrappedError instanceof ResourceAlreadyExistsException) {
            return new RelationAlreadyExists(((ResourceAlreadyExistsException)unwrappedError).getIndex(), unwrappedError);
        }
        if (unwrappedError instanceof InvalidIndexNameException) {
            if (unwrappedError.getMessage().contains("already exists as alias")) {
                return new RelationAlreadyExists(((InvalidIndexNameException)unwrappedError).getIndex(), unwrappedError);
            }
            return new InvalidRelationName(((InvalidIndexNameException)unwrappedError).getIndex().getName(), unwrappedError);
        }
        if (unwrappedError instanceof InvalidIndexTemplateException) {
            PartitionName partitionName = PartitionName.fromIndexOrTemplate(((InvalidIndexTemplateException)unwrappedError).name());
            return new InvalidRelationName(partitionName.relationName().fqn(), unwrappedError);
        }
        if (unwrappedError instanceof IndexNotFoundException) {
            return new RelationUnknown(((IndexNotFoundException)unwrappedError).getIndex().getName(), unwrappedError);
        }
        if (unwrappedError instanceof InterruptedException) {
            return JobKilledException.of(unwrappedError.getMessage());
        }
        return unwrappedError;
    }

    public static boolean isDocumentAlreadyExistsException(Throwable e) {
        return e instanceof VersionConflictEngineException && e.getMessage().contains("document already exists");
    }
}

