/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.UnscopedException;
import io.crate.rest.action.HttpErrorStatus;
import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;

public class VersioningValidationException
extends ElasticsearchException
implements UnscopedException {
    public static final String VERSION_COLUMN_USAGE_MSG = "\"_version\" column can only be used in the WHERE clause with equals comparisons and if there are also equals comparisons on primary key columns";
    public static final String SEQ_NO_AND_PRIMARY_TERM_USAGE_MSG = "\"_seq_no\" and \"_primary_term\" columns can only be used together in the WHERE clause with equals comparisons and if there are also equals comparisons on primary key columns";
    public static final String MIXED_VERSIONING_COLUMNS_USAGE_MSG = "\"_version\" column cannot be used in conjunction with the \"_seq_no\" and \"_primary_term\" columns. Use one of the two versioning mechanisms, but not both at the same time.";

    private VersioningValidationException(String errorMessage) {
        super(errorMessage, new Object[0]);
    }

    public static VersioningValidationException versionInvalidUsage() {
        return new VersioningValidationException(VERSION_COLUMN_USAGE_MSG);
    }

    public static VersioningValidationException seqNoAndPrimaryTermUsage() {
        return new VersioningValidationException(SEQ_NO_AND_PRIMARY_TERM_USAGE_MSG);
    }

    public static VersioningValidationException mixedVersioningMeachanismsUsage() {
        return new VersioningValidationException(MIXED_VERSIONING_COLUMNS_USAGE_MSG);
    }

    public VersioningValidationException(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.STATEMENT_INVALID_OR_UNSUPPORTED_SYNTAX;
    }
}

