/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.common.exceptions.Exceptions;
import io.crate.exceptions.SQLExceptions;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.delete.TransportDeleteRepository;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.put.TransportPutRepository;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.RepositoriesMetadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class RepositoryService {
    private static final Logger LOGGER = LogManager.getLogger(RepositoryService.class);
    private final ClusterService clusterService;
    private final NodeClient client;

    public RepositoryService(ClusterService clusterService, NodeClient client) {
        this.clusterService = clusterService;
        this.client = client;
    }

    @Nullable
    public RepositoryMetadata getRepository(String repositoryName) {
        RepositoriesMetadata repositories = (RepositoriesMetadata)this.clusterService.state().metadata().custom("repositories");
        if (repositories != null) {
            return repositories.repository(repositoryName);
        }
        return null;
    }

    public void failIfRepositoryDoesNotExist(String repositoryName) {
        if (this.getRepository(repositoryName) == null) {
            throw new RepositoryMissingException(repositoryName);
        }
    }

    public CompletableFuture<Long> execute(DeleteRepositoryRequest request) {
        return this.client.execute(TransportDeleteRepository.ACTION, request).thenApply(response -> {
            if (!response.isAcknowledged()) {
                LOGGER.info("delete repository '{}' not acknowledged", (Object)request.name());
            }
            return 1L;
        });
    }

    public CompletableFuture<Long> execute(PutRepositoryRequest request) {
        return ((CompletableFuture)this.client.execute(TransportPutRepository.ACTION, request).thenApply(r -> 1L)).exceptionallyCompose(err -> {
            Throwable t = RepositoryService.convertRepositoryException(err);
            return this.dropIfExists(request.name()).thenApply(ignored -> {
                throw Exceptions.toRuntimeException((Throwable)t);
            });
        });
    }

    private CompletableFuture<Long> dropIfExists(String repoName) {
        RepositoryMetadata repository = this.getRepository(repoName);
        if (repository == null) {
            return CompletableFuture.completedFuture(1L);
        }
        return this.execute(new DeleteRepositoryRequest(repoName)).exceptionally(err -> {
            LOGGER.error("Error occurred whilst trying to delete repository", err);
            return -1L;
        });
    }

    @VisibleForTesting
    static Throwable convertRepositoryException(Throwable e) {
        e = SQLExceptions.unwrap(e);
        Throwable cause = e.getCause();
        if (e instanceof RepositoryException && cause != null) {
            Object msg = e.getMessage();
            if (cause instanceof CreationException && cause.getCause() != null) {
                msg = (String)msg + ": " + cause.getCause().getMessage();
            }
            return new RepositoryException("", (String)msg, e);
        }
        return e;
    }
}

