/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DropPartitionsRequest
extends AcknowledgedRequest<DropPartitionsRequest> {
    private final RelationName relationName;
    private final List<PartitionName> partitions;

    public DropPartitionsRequest(RelationName relationName, List<PartitionName> partitions) {
        this.relationName = relationName;
        this.partitions = partitions;
    }

    public RelationName relationName() {
        return this.relationName;
    }

    public List<PartitionName> partitions() {
        return this.partitions;
    }

    public DropPartitionsRequest(StreamInput in) throws IOException {
        super(in);
        this.relationName = new RelationName(in);
        int size = in.readVInt();
        this.partitions = new ArrayList<PartitionName>(size);
        for (int i = 0; i < size; ++i) {
            int numValues = in.readVInt();
            ArrayList<String> values = new ArrayList<String>(numValues);
            for (int j = 0; j < numValues; ++j) {
                values.add(in.readOptionalString());
            }
            this.partitions.add(new PartitionName(this.relationName, values));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.relationName.writeTo(out);
        out.writeVInt(this.partitions.size());
        for (PartitionName partition : this.partitions) {
            assert (partition.relationName().equals(this.relationName)) : "RelationName of PartitionName must match requets' relationName";
            List<String> values = partition.values();
            out.writeVInt(values.size());
            for (String value : values) {
                out.writeOptionalString(value);
            }
        }
    }
}

