/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.common.collections.Lists;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.IndexReference;
import io.crate.metadata.Reference;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.ColumnPolicy;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.jetbrains.annotations.Nullable;

public final class MappingUtil {
    public static final String DROPPED_COLUMN_NAME_PREFIX = "_dropped_";

    private MappingUtil() {
    }

    public static Map<String, Object> createMapping(AllocPosition allocPosition, @Nullable String pkConstraintName, List<Reference> columns, List<ColumnIdent> primaryKeys, Map<String, String> checkConstraints, List<ColumnIdent> partitionedBy, @Nullable ColumnPolicy tableColumnPolicy, @Nullable ColumnIdent routingColumn) {
        HashMap<ColumnIdent, List<Reference>> tree = Reference.buildTree(columns);
        Map<String, Map<String, Object>> propertiesMap = MappingUtil.toProperties(allocPosition, null, tree);
        assert (propertiesMap != null) : "ADD COLUMN mapping can not be null";
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        HashMap<String, Object> meta = new HashMap<String, Object>();
        if (pkConstraintName != null) {
            meta.put("pk_constraint_name", pkConstraintName);
        }
        MappingUtil.mergeConstraints(meta, columns, primaryKeys, checkConstraints);
        if (routingColumn != null) {
            meta.put("routing", routingColumn.fqn());
        }
        if (tableColumnPolicy != null) {
            mapping.put("dynamic", tableColumnPolicy.toMappingValue());
        }
        HashMap indices = new HashMap();
        for (Reference column : columns) {
            IndexReference indexRef;
            if (!(column instanceof IndexReference) || (indexRef = (IndexReference)column).columns().isEmpty()) continue;
            indices.put(column.storageIdent(), Map.of());
        }
        if (!indices.isEmpty()) {
            meta.put("indices", indices);
        }
        if (!partitionedBy.isEmpty()) {
            List pColumns = Lists.map(partitionedBy, pColumn -> {
                int refIdx = Reference.indexOf(columns, pColumn);
                Reference pRef = (Reference)columns.get(refIdx);
                return MappingUtil.toPartitionMapping(pRef);
            });
            meta.put("partitioned_by", pColumns);
        }
        mapping.put("_meta", meta);
        mapping.put("properties", propertiesMap);
        return mapping;
    }

    private static List<String> toPartitionMapping(Reference ref) {
        String fqn = ref.column().fqn();
        String typeMappingName = DataTypes.esMappingNameFrom(ref.valueType().id());
        return List.of(fqn, typeMappingName);
    }

    public static Map<String, Map<String, Object>> toProperties(AllocPosition allocPosition, HashMap<ColumnIdent, List<Reference>> tree) {
        return MappingUtil.toProperties(allocPosition, null, tree);
    }

    @Nullable
    private static Map<String, Map<String, Object>> toProperties(AllocPosition position, @Nullable ColumnIdent currentNode, HashMap<ColumnIdent, List<Reference>> tree) {
        List<Reference> children = tree.get(currentNode);
        if (children == null) {
            return null;
        }
        LinkedHashMap<String, Map<String, Object>> allColumnsMap = new LinkedHashMap<String, Map<String, Object>>();
        for (Reference child : children) {
            allColumnsMap.put(MappingUtil.mappingKey(child), MappingUtil.addColumnProperties(position, child, tree));
        }
        return allColumnsMap;
    }

    private static String mappingKey(Reference reference) {
        if (reference.isDropped()) {
            assert (reference.oid() != 0L) : "Only columns with assigned OID-s can be dropped";
            return DROPPED_COLUMN_NAME_PREFIX + reference.oid();
        }
        return reference.column().leafName();
    }

    private static Map<String, Object> addColumnProperties(AllocPosition position, Reference reference, HashMap<ColumnIdent, List<Reference>> tree) {
        Map<String, Object> leafProperties;
        Map<String, Object> properties = leafProperties = reference.toMapping(position.position(reference.column()));
        DataType<Object> valueType = reference.valueType();
        while (valueType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)valueType;
            HashMap<String, Object> arrayMapping = new HashMap<String, Object>();
            arrayMapping.put("type", "array");
            arrayMapping.put("inner", properties);
            valueType = arrayType.innerType();
            properties = arrayMapping;
        }
        if (valueType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)valueType;
            MappingUtil.objectMapping(position, leafProperties, objectType, reference.column(), tree);
        }
        return properties;
    }

    private static void objectMapping(AllocPosition position, Map<String, Object> propertiesMap, ObjectType objectType, ColumnIdent columnIdent, HashMap<ColumnIdent, List<Reference>> tree) {
        propertiesMap.put("dynamic", objectType.columnPolicy().toMappingValue());
        Map<String, Map<String, Object>> nestedObjectMap = MappingUtil.toProperties(position, columnIdent, tree);
        if (nestedObjectMap != null) {
            propertiesMap.put("properties", nestedObjectMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeConstraints(Map<String, Object> meta, List<Reference> references, List<ColumnIdent> primaryKeys, Map<String, String> checkConstraints) {
        List<GeneratedReference> newGenExpressions;
        if (!checkConstraints.isEmpty()) {
            LinkedHashMap<String, String> existingCheckConstraints = (LinkedHashMap<String, String>)meta.get("check_constraints");
            if (existingCheckConstraints == null) {
                existingCheckConstraints = new LinkedHashMap<String, String>();
                meta.put("check_constraints", existingCheckConstraints);
            }
            for (Map.Entry entry : checkConstraints.entrySet()) {
                String name = (String)entry.getKey();
                String expression = (String)entry.getValue();
                existingCheckConstraints.put(name, expression);
            }
        }
        if (!primaryKeys.isEmpty()) {
            ArrayList<String> fqPrimaryKeys = (ArrayList<String>)meta.get("primary_keys");
            if (fqPrimaryKeys == null) {
                fqPrimaryKeys = new ArrayList<String>();
                meta.put("primary_keys", fqPrimaryKeys);
            }
            for (ColumnIdent columnIdent : primaryKeys) {
                fqPrimaryKeys.add(columnIdent.fqn());
            }
        }
        ArrayList<String> newNotNulls = new ArrayList<String>();
        for (int i = 0; i < references.size(); ++i) {
            Reference reference = references.get(i);
            if (reference.isNullable() || primaryKeys.contains(reference.column())) continue;
            newNotNulls.add(reference.column().fqn());
        }
        if (!newNotNulls.isEmpty()) {
            void var6_16;
            List list;
            Map constraints = (Map)meta.get("constraints");
            List list2 = list = constraints != null ? (List)constraints.get("not_null") : null;
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                HashMap map = new HashMap();
                map.put("not_null", arrayList);
                meta.put("constraints", map);
            }
            var6_16.addAll(newNotNulls);
        }
        if (!(newGenExpressions = references.stream().filter(ref -> ref instanceof GeneratedReference && !ref.isDropped()).map(ref -> (GeneratedReference)ref).toList()).isEmpty()) {
            Map map = (Map)meta.get("generated_columns");
            if (map == null) {
                HashMap hashMap = new HashMap();
                meta.put("generated_columns", hashMap);
            }
            for (GeneratedReference genRef : newGenExpressions) {
                void var6_20;
                var6_20.put(genRef.column().fqn(), genRef.formattedGeneratedExpression());
            }
        }
    }

    public static class AllocPosition {
        private final ToIntFunction<ColumnIdent> getExistingPosition;
        private int nextPosition;

        public static AllocPosition forTable(TableInfo table) {
            return new AllocPosition(table.maxPosition(), column -> {
                Reference reference = table.getReference((ColumnIdent)column);
                if (reference == null) {
                    for (Reference droppedColumn : table.droppedColumns()) {
                        if (!droppedColumn.column().equals(column)) continue;
                        return droppedColumn.position();
                    }
                    return -1;
                }
                return reference.position();
            });
        }

        public static AllocPosition forTable(RelationMetadata.Table table) {
            int maxPosition = 0;
            HashMap<ColumnIdent, Integer> colPositions = new HashMap<ColumnIdent, Integer>();
            HashMap<ColumnIdent, Integer> droppedColPositions = new HashMap<ColumnIdent, Integer>();
            for (Reference reference : table.columns()) {
                if (reference.isDropped()) {
                    droppedColPositions.put(reference.column(), reference.position());
                } else {
                    colPositions.put(reference.column(), reference.position());
                }
                if (reference.position() <= maxPosition) continue;
                maxPosition = reference.position();
            }
            return new AllocPosition(maxPosition, column -> {
                Integer position = (Integer)colPositions.get(column);
                if (position == null) {
                    position = (Integer)droppedColPositions.get(column);
                }
                return Objects.requireNonNullElse(position, -1);
            });
        }

        public static AllocPosition forNewTable() {
            return new AllocPosition(0, column -> -1);
        }

        private AllocPosition(int maxPosition, ToIntFunction<ColumnIdent> getExistingPosition) {
            this.getExistingPosition = getExistingPosition;
            this.nextPosition = maxPosition + 1;
        }

        public int position(ColumnIdent column) {
            int position = this.getExistingPosition.applyAsInt(column);
            if (position < 0) {
                return this.nextPosition++;
            }
            return position;
        }
    }
}

