/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OpenTableRequest
extends AcknowledgedRequest<OpenTableRequest> {
    private final RelationName relation;
    private final List<String> partitionValues;

    public OpenTableRequest(RelationName relation, List<String> partitionValues) {
        this.relation = relation;
        this.partitionValues = partitionValues;
    }

    public RelationName relation() {
        return this.relation;
    }

    public List<String> partitionValues() {
        return this.partitionValues;
    }

    public OpenTableRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().before(Version.V_5_10_0)) {
            this.relation = new RelationName(in);
            String partitionIndexName = in.readOptionalString();
            this.partitionValues = partitionIndexName == null ? List.of() : PartitionName.fromIndexOrTemplate(partitionIndexName).values();
            in.readBoolean();
        } else {
            this.relation = new RelationName(in);
            int numValues = in.readVInt();
            this.partitionValues = new ArrayList<String>(numValues);
            for (int i = 0; i < numValues; ++i) {
                this.partitionValues.add(in.readOptionalString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_5_10_0)) {
            this.relation.writeTo(out);
            if (this.partitionValues.isEmpty()) {
                out.writeBoolean(false);
            } else {
                String indexName = new PartitionName(this.relation, this.partitionValues).asIndexName();
                out.writeBoolean(true);
                out.writeString(indexName);
            }
            out.writeBoolean(true);
        } else {
            this.relation.writeTo(out);
            out.writeVInt(this.partitionValues.size());
            for (String partitionValue : this.partitionValues) {
                out.writeOptionalString(partitionValue);
            }
        }
    }
}

