/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.metadata.RelationName;
import java.io.IOException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class RenameTableRequest
extends AcknowledgedRequest<RenameTableRequest> {
    private final RelationName sourceName;
    private final RelationName targetName;
    private final boolean isPartitioned;

    public RenameTableRequest(RelationName sourceName, RelationName targetName, boolean isPartitioned) {
        this.sourceName = sourceName;
        this.targetName = targetName;
        this.isPartitioned = isPartitioned;
    }

    public RelationName sourceName() {
        return this.sourceName;
    }

    public RelationName targetName() {
        return this.targetName;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public RenameTableRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceName = new RelationName(in);
        this.targetName = new RelationName(in);
        this.isPartitioned = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceName.writeTo(out);
        this.targetName.writeTo(out);
        out.writeBoolean(this.isPartitioned);
    }
}

