/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.AddColumnRequest;
import io.crate.execution.ddl.tables.AlterTableTask;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.doc.DocTableInfo;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportAddColumn
extends AbstractDDLTransportAction<AddColumnRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    @VisibleForTesting
    public static final AlterTableTask.AlterTableOperator<AddColumnRequest> ADD_COLUMN_OPERATOR = (req, doctableInfo, metadataBuilder, nodeCtx, fulltextAnalyzerResolver) -> doctableInfo.addColumns(nodeCtx, fulltextAnalyzerResolver, doctableInfo.versionCreated().onOrAfter(DocTableInfo.COLUMN_OID_VERSION) ? metadataBuilder.columnOidSupplier() : () -> 0L, req.references(), req.pKeyIndices(), req.checkConstraints());
    private final NodeContext nodeContext;
    private final FulltextAnalyzerResolver fulltextAnalyzerResolver;

    @Inject
    public TransportAddColumn(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, NodeContext nodeContext, FulltextAnalyzerResolver fulltextAnalyzerResolver) {
        super(ACTION.name(), transportService, clusterService, threadPool, AddColumnRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "add-column");
        this.nodeContext = nodeContext;
        this.fulltextAnalyzerResolver = fulltextAnalyzerResolver;
    }

    @Override
    public ClusterStateTaskExecutor<AddColumnRequest> clusterStateTaskExecutor(AddColumnRequest request) {
        return new AlterTableTask<AddColumnRequest>(this.nodeContext, request.relationName(), this.fulltextAnalyzerResolver, ADD_COLUMN_OPERATOR);
    }

    @Override
    public ClusterBlockException checkBlock(AddColumnRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:sql/table/add_column";

        private Action() {
            super(NAME);
        }
    }
}

