/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.GCDanglingArtifactsRequest;
import io.crate.metadata.cluster.DDLClusterStateTaskExecutor;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportGCDanglingArtifacts
extends AbstractDDLTransportAction<GCDanglingArtifactsRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final DDLClusterStateTaskExecutor<GCDanglingArtifactsRequest> executor;

    @Inject
    public TransportGCDanglingArtifacts(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, final MetadataDeleteIndexService deleteIndexService) {
        super(ACTION.name(), transportService, clusterService, threadPool, GCDanglingArtifactsRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "gc");
        this.executor = new DDLClusterStateTaskExecutor<GCDanglingArtifactsRequest>(this){

            @Override
            protected ClusterState execute(ClusterState currentState, GCDanglingArtifactsRequest gcDanglingArtifactsRequest) {
                Metadata metadata = currentState.metadata();
                HashSet<Index> danglingIndicesToDelete = new HashSet<Index>();
                HashSet<Index> allTableIndices = new HashSet<Index>();
                for (RelationMetadata rm : metadata.relations(RelationMetadata.class)) {
                    allTableIndices.addAll(metadata.getIndices(rm.name(), List.of(), false, IndexMetadata::getIndex));
                }
                for (ObjectCursor indexMetadata : metadata.indices().values()) {
                    Index index = ((IndexMetadata)indexMetadata.value).getIndex();
                    if (allTableIndices.contains(index)) continue;
                    danglingIndicesToDelete.add(index);
                }
                if (danglingIndicesToDelete.isEmpty()) {
                    return currentState;
                }
                return deleteIndexService.deleteIndices(currentState, danglingIndicesToDelete);
            }
        };
    }

    @Override
    public ClusterStateTaskExecutor<GCDanglingArtifactsRequest> clusterStateTaskExecutor(GCDanglingArtifactsRequest request) {
        return this.executor;
    }

    @Override
    protected ClusterBlockException checkBlock(GCDanglingArtifactsRequest request, ClusterState state) {
        return null;
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "internal:crate:admin/gc";

        private Action() {
            super(NAME);
        }
    }
}

