/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.views;

import io.crate.common.unit.TimeValue;
import io.crate.metadata.RelationName;
import io.crate.metadata.SearchPath;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public final class CreateViewRequest
extends MasterNodeRequest<CreateViewRequest>
implements AckedRequest {
    private final RelationName name;
    private final String query;
    private final boolean replaceExisting;
    private final SearchPath searchPath;
    @Nullable
    private final String owner;
    private final boolean errorOnUnknownObjectKey;

    public CreateViewRequest(RelationName name, String query, boolean replaceExisting, SearchPath searchPath, @Nullable String owner, boolean errorOnUnknownObjectKey) {
        this.name = name;
        this.query = query;
        this.replaceExisting = replaceExisting;
        this.searchPath = searchPath;
        this.owner = owner;
        this.errorOnUnknownObjectKey = errorOnUnknownObjectKey;
    }

    public RelationName name() {
        return this.name;
    }

    public String query() {
        return this.query;
    }

    boolean replaceExisting() {
        return this.replaceExisting;
    }

    public SearchPath searchPath() {
        return this.searchPath;
    }

    public boolean errorOnUnknownObjectKey() {
        return this.errorOnUnknownObjectKey;
    }

    @Nullable
    String owner() {
        return this.owner;
    }

    @Override
    public TimeValue ackTimeout() {
        return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
    }

    public CreateViewRequest(StreamInput in) throws IOException {
        super(in);
        this.name = new RelationName(in);
        this.query = in.readString();
        this.replaceExisting = in.readBoolean();
        this.owner = in.readOptionalString();
        Version version = in.getVersion();
        this.searchPath = version.after(Version.V_5_3_4) && !version.equals(Version.V_5_4_0) ? SearchPath.createSearchPathFrom(in) : SearchPath.pathWithPGCatalogAndDoc();
        this.errorOnUnknownObjectKey = version.after(Version.V_5_10_5) ? in.readBoolean() : true;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.name.writeTo(out);
        out.writeString(this.query);
        out.writeBoolean(this.replaceExisting);
        out.writeOptionalString(this.owner);
        Version version = out.getVersion();
        if (version.after(Version.V_5_3_4) && !version.equals(Version.V_5_4_0)) {
            this.searchPath.writeTo(out);
        }
        if (version.after(Version.V_5_10_5)) {
            out.writeBoolean(this.errorOnUnknownObjectKey);
        }
    }
}

