/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.views;

import io.crate.execution.ddl.views.DropViewRequest;
import io.crate.execution.ddl.views.DropViewResponse;
import io.crate.metadata.RelationName;
import io.crate.metadata.cluster.DDLClusterStateService;
import io.crate.metadata.view.ViewsMetadata;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class TransportDropView
extends TransportMasterNodeAction<DropViewRequest, DropViewResponse> {
    public static final Action ACTION = new Action();
    private final DDLClusterStateService ddlClusterStateService;

    @Inject
    public TransportDropView(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, DDLClusterStateService ddlClusterStateService) {
        super(ACTION.name(), transportService, clusterService, threadPool, DropViewRequest::new);
        this.ddlClusterStateService = ddlClusterStateService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected DropViewResponse read(StreamInput in) throws IOException {
        return new DropViewResponse(in);
    }

    @Override
    protected void masterOperation(final DropViewRequest request, ClusterState state, ActionListener<DropViewResponse> listener) {
        this.clusterService.submitStateUpdateTask("views/drop", new AckedClusterStateUpdateTask<DropViewResponse>(this, Priority.HIGH, (AckedRequest)request, listener){
            private List<RelationName> missing;
            final /* synthetic */ TransportDropView this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                ViewsMetadata views = (ViewsMetadata)currentState.metadata().custom("views");
                if (views == null) {
                    this.missing = request.names();
                    return currentState;
                }
                ViewsMetadata.RemoveResult removeResult = views.remove(request.names());
                this.missing = removeResult.missing();
                if (!removeResult.missing().isEmpty() && !request.ifExists()) {
                    return currentState;
                }
                currentState = this.this$0.ddlClusterStateService.onDropView(currentState, request.names());
                return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("views", removeResult.updatedViews()).build()).build();
            }

            @Override
            protected DropViewResponse newResponse(boolean acknowledged) {
                return new DropViewResponse(this.missing);
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(DropViewRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<DropViewResponse> {
        private static final String NAME = "internal:crate:sql/views/drop";

        private Action() {
            super(NAME);
        }
    }
}

