/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class DynamicIndexer
implements ValueIndexer<Object> {
    private final ReferenceIdent refIdent;
    private final Function<ColumnIdent, Reference> getRef;
    private final int position;
    private final boolean useOids;
    private DataType<?> type = null;
    private ValueIndexer<Object> indexer;

    public DynamicIndexer(ReferenceIdent refIdent, int position, Function<ColumnIdent, Reference> getRef, boolean useOids) {
        this.refIdent = refIdent;
        this.getRef = getRef;
        this.position = position;
        this.useOids = useOids;
    }

    public static Reference buildReference(ReferenceIdent refIdent, DataType<?> type, int position, long oid) {
        StorageSupport<?> storageSupport = type.storageSupport();
        if (storageSupport == null) {
            throw new IllegalArgumentException("Cannot create columns of type " + type.getName() + " dynamically. Storage is not supported for this type");
        }
        return new SimpleReference(refIdent, RowGranularity.DOC, type, IndexType.PLAIN, true, storageSupport.docValuesDefault(), position, oid, false, null);
    }

    @Override
    public void collectSchemaUpdates(Object value, Consumer<? super Reference> onDynamicColumn, ValueIndexer.Synthetics synthetics) throws IOException {
        if (this.type == null) {
            this.type = DynamicIndexer.guessType(value);
            Reference newColumn = DynamicIndexer.buildReference(this.refIdent, this.type, this.position, 0L);
            StorageSupport<?> storageSupport = this.type.storageSupport();
            assert (storageSupport != null);
            this.indexer = storageSupport.valueIndexer(this.refIdent.tableIdent(), newColumn, this.getRef);
            onDynamicColumn.accept(newColumn);
        }
        value = this.type.sanitizeValue(value);
        this.indexer.collectSchemaUpdates(value, onDynamicColumn, synthetics);
    }

    @Override
    public void indexValue(@NotNull Object value, IndexDocumentBuilder docBuilder) throws IOException {
        StorageSupport<?> storageSupport;
        if (this.type == null) {
            this.type = DynamicIndexer.guessType(value);
        }
        if ((storageSupport = this.type.storageSupport()) == null) {
            throw new IllegalArgumentException("Cannot create columns of type " + this.type.getName() + " dynamically. Storage is not supported for this type");
        }
        Reference newColumn = DynamicIndexer.buildReference(this.refIdent, this.type, this.position, 0L);
        if (this.indexer == null) {
            this.indexer = storageSupport.valueIndexer(this.refIdent.tableIdent(), newColumn, this.getRef);
        }
        value = this.type.sanitizeValue(value);
        this.indexer.indexValue(value, docBuilder);
    }

    @Override
    public String storageIdentLeafName() {
        return this.useOids ? "_u_" + this.refIdent.columnIdent().leafName() : this.refIdent.columnIdent().leafName();
    }

    static DataType<?> guessType(Object value) {
        DataType<?> type = DataTypes.guessType(value);
        if (type instanceof ArrayType) {
            DataType<Object> innerType = type;
            int dimensions = 0;
            while (innerType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)innerType;
                innerType = arrayType.innerType();
                ++dimensions;
            }
            return ArrayType.makeArray(DataTypes.upcast(innerType), dimensions);
        }
        return DataTypes.upcast(type);
    }
}

