/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import io.crate.types.FloatVectorType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.NotNull;

public class FloatVectorIndexer
implements ValueIndexer<float[]> {
    public static final FieldType FIELD_TYPE = new FieldType();
    final FieldType fieldType = new FieldType((IndexableFieldType)FIELD_TYPE);
    private final String name;
    private final Reference ref;

    public FloatVectorIndexer(Reference ref) {
        this.fieldType.setVectorAttributes(ref.valueType().characterMaximumLength().intValue(), VectorEncoding.FLOAT32, FloatVectorType.SIMILARITY_FUNC);
        this.ref = ref;
        this.name = ref.storageIdent();
    }

    @Override
    public void indexValue(float @NotNull [] values, IndexDocumentBuilder docBuilder) throws IOException {
        FloatVectorIndexer.createFields(this.name, this.fieldType, this.ref.indexType() != IndexType.NONE, this.ref.hasDocValues(), !this.ref.hasDocValues() && docBuilder.maybeAddStoredField(), values, docBuilder::addField);
        if (this.fieldType.stored()) {
            throw new UnsupportedOperationException("Cannot store float_vector as stored field");
        }
        docBuilder.translogWriter().writeValue(values);
    }

    public static void createFields(String fqn, FieldType fieldType, boolean indexed, boolean hasDocValues, boolean hasStoredField, float @NotNull [] values, Consumer<? super IndexableField> addField) {
        if (indexed) {
            addField.accept((IndexableField)new KnnFloatVectorField(fqn, values, fieldType));
        }
        BytesRef byteRepresentation = null;
        if (hasDocValues || hasStoredField) {
            byte[] bytes = new byte[4 * values.length];
            ByteBuffer.wrap(bytes).asFloatBuffer().put(values);
            byteRepresentation = new BytesRef(bytes);
        }
        if (hasDocValues) {
            BinaryDocValuesField field = new BinaryDocValuesField(fqn, byteRepresentation);
            addField.accept((IndexableField)field);
        } else {
            if (hasStoredField) {
                addField.accept((IndexableField)new StoredField(fqn, byteRepresentation));
            }
            addField.accept((IndexableField)new Field("_field_names", (CharSequence)fqn, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
        }
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }

    static {
        FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.freeze();
    }
}

