/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.delete;

import io.crate.common.exceptions.Exceptions;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.TransportShardAction;
import io.crate.execution.dml.delete.ShardDeleteRequest;
import io.crate.execution.jobs.TasksService;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportShardDeleteAction
extends TransportShardAction<ShardDeleteRequest, ShardDeleteRequest, ShardDeleteRequest.Item, ShardDeleteRequest.Item> {
    @Inject
    public TransportShardDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, TasksService tasksService, ThreadPool threadPool, ShardStateAction shardStateAction, CircuitBreakerService circuitBreakerService) {
        super(settings, "internal:crate:sql/data/delete", transportService, clusterService, indicesService, tasksService, threadPool, shardStateAction, circuitBreakerService, ShardDeleteRequest::new, ShardDeleteRequest::new);
    }

    @Override
    protected TransportWriteAction.WritePrimaryResult<ShardDeleteRequest, ShardResponse> processRequestItems(IndexShard indexShard, ShardDeleteRequest request, AtomicBoolean killed) throws IOException {
        ShardResponse shardResponse = new ShardResponse();
        Translog.Location translogLocation = null;
        boolean debugEnabled = this.logger.isDebugEnabled();
        ShardDeleteRequest replicaRequest = new ShardDeleteRequest(request.shardId(), request.jobId());
        for (ShardDeleteRequest.Item item : request.items()) {
            int location = item.location();
            if (killed.get()) {
                replicaRequest.skipFromLocation(location);
                shardResponse.failure(new InterruptedException("Job killed"));
                break;
            }
            try {
                Engine.DeleteResult deleteResult = indexShard.applyDeleteOperationOnPrimary(item.version(), item.id(), VersionType.INTERNAL, item.seqNo(), item.primaryTerm());
                translogLocation = deleteResult.getTranslogLocation();
                Exception failure = deleteResult.getFailure();
                if (debugEnabled) {
                    this.logResult("primary", request.shardId(), item.id(), deleteResult);
                }
                if (failure == null) {
                    if (deleteResult.isFound()) {
                        shardResponse.add(location);
                        ShardDeleteRequest.Item resultItem = new ShardDeleteRequest.Item(item.id(), deleteResult.getSeqNo(), deleteResult.getTerm(), deleteResult.getVersion());
                        replicaRequest.add(location, resultItem);
                        continue;
                    }
                    DocumentMissingException ex = new DocumentMissingException(indexShard.shardId(), item.id());
                    shardResponse.add(location, item.id(), ex, false);
                    continue;
                }
                shardResponse.add(location, item.id(), failure, failure instanceof VersionConflictEngineException);
            }
            catch (Exception e) {
                if (TransportShardDeleteAction.retryPrimaryException(e)) {
                    throw Exceptions.toRuntimeException((Throwable)e);
                }
                if (debugEnabled) {
                    this.logger.debug("shardId={} failed to execute delete for id={}: {}", (Object)request.shardId(), (Object)item.id(), (Object)e);
                }
                shardResponse.add(location, item.id(), e, e instanceof VersionConflictEngineException);
            }
        }
        return new TransportWriteAction.WritePrimaryResult<ShardDeleteRequest, ShardResponse>(replicaRequest, shardResponse, translogLocation, indexShard);
    }

    private void logResult(String origin, ShardId shardId, String id, Engine.DeleteResult deleteResult) {
        this.logger.debug("shardId={} delete {} op id={} failure={} seqNo={} found={}", (Object)shardId, (Object)origin, (Object)id, (Object)deleteResult.getFailure(), (Object)deleteResult.getSeqNo(), (Object)deleteResult.isFound());
    }

    @Override
    protected TransportWriteAction.WriteReplicaResult processRequestItemsOnReplica(IndexShard indexShard, ShardDeleteRequest request) throws IOException {
        Translog.Location translogLocation = null;
        boolean traceEnabled = this.logger.isTraceEnabled();
        for (ShardDeleteRequest.Item item : request.items()) {
            int location = item.location();
            if (request.skipFromLocation() == location) break;
            if (item.seqNo() == -2L) continue;
            Engine.DeleteResult deleteResult = indexShard.applyDeleteOperationOnReplica(item.seqNo(), item.primaryTerm(), item.version(), item.id());
            translogLocation = deleteResult.getTranslogLocation();
            if (!traceEnabled) continue;
            this.logResult("replica", request.shardId(), item.id(), deleteResult);
        }
        return new TransportWriteAction.WriteReplicaResult(translogLocation, indexShard);
    }
}

