/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.Streamer;
import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.FetchPhase;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.dsl.phases.ForeignCollectPhase;
import io.crate.execution.dsl.phases.HashJoinPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.phases.NestedLoopPhase;
import io.crate.execution.dsl.phases.PKLookupPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;

public interface ExecutionPhase
extends Writeable {
    public static final String DIRECT_RESPONSE = "_response";
    public static final List<String> DIRECT_RESPONSE_LIST = Collections.singletonList("_response");
    public static final int NO_EXECUTION_PHASE = Integer.MAX_VALUE;

    public Type type();

    public String name();

    public int phaseId();

    public Collection<String> nodeIds();

    public <C, R> R accept(ExecutionPhaseVisitor<C, R> var1, C var2);

    public Streamer<?>[] getStreamers();

    default public String label() {
        return this.name() + ": " + this.phaseId();
    }

    public static enum Type {
        COLLECT(RoutedCollectPhase::new),
        COUNT(CountPhase::new),
        FILE_URI_COLLECT(FileUriCollectPhase::new),
        MERGE(MergePhase::new),
        FETCH(FetchPhase::new),
        NESTED_LOOP(NestedLoopPhase::new),
        HASH_JOIN(HashJoinPhase::new),
        TABLE_FUNCTION_COLLECT(in -> {
            throw new UnsupportedOperationException("TableFunctionCollectPhase is not streamable");
        }),
        PKLookup(PKLookupPhase::new),
        FOREIGN_COLLECT(ForeignCollectPhase::new);

        public static final List<Type> VALUES;
        private final Writeable.Reader<ExecutionPhase> reader;

        private Type(Writeable.Reader<ExecutionPhase> reader) {
            this.reader = reader;
        }

        public ExecutionPhase fromStream(StreamInput in) throws IOException {
            return this.reader.read(in);
        }

        static {
            VALUES = List.of(Type.values());
        }
    }
}

