/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.Streamer;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FetchPhase
implements ExecutionPhase {
    private final TreeMap<String, Integer> bases;
    private final Map<RelationName, Collection<String>> tableIndices;
    private final Collection<Reference> fetchRefs;
    private final int executionPhaseId;
    private final Set<String> executionNodes;

    public FetchPhase(int executionPhaseId, Set<String> executionNodes, TreeMap<String, Integer> bases, Map<RelationName, Collection<String>> tableIndices, Collection<Reference> fetchRefs) {
        this.executionPhaseId = executionPhaseId;
        this.executionNodes = executionNodes;
        this.bases = bases;
        this.tableIndices = tableIndices;
        this.fetchRefs = fetchRefs;
    }

    public Collection<Reference> fetchRefs() {
        return this.fetchRefs;
    }

    @Override
    public ExecutionPhase.Type type() {
        return ExecutionPhase.Type.FETCH;
    }

    @Override
    public String name() {
        return "fetchPhase";
    }

    @Override
    public int phaseId() {
        return this.executionPhaseId;
    }

    public Set<String> nodeIds() {
        return this.executionNodes;
    }

    @Override
    public <C, R> R accept(ExecutionPhaseVisitor<C, R> visitor, C context) {
        return visitor.visitFetchPhase(this, context);
    }

    public FetchPhase(StreamInput in) throws IOException {
        int i;
        this.executionPhaseId = in.readVInt();
        int n = in.readVInt();
        this.executionNodes = new HashSet<String>(n);
        for (i = 0; i < n; ++i) {
            this.executionNodes.add(in.readString());
        }
        n = in.readVInt();
        this.bases = new TreeMap();
        for (i = 0; i < n; ++i) {
            this.bases.put(in.readString(), in.readVInt());
        }
        n = in.readVInt();
        this.fetchRefs = new ArrayList<Reference>(n);
        for (i = 0; i < n; ++i) {
            this.fetchRefs.add((Reference)Reference.fromStream(in));
        }
        n = in.readVInt();
        this.tableIndices = new HashMap<RelationName, Collection<String>>(n);
        for (i = 0; i < n; ++i) {
            RelationName ti = new RelationName(in);
            int nn = in.readVInt();
            for (int j = 0; j < nn; ++j) {
                Collection collection = this.tableIndices.computeIfAbsent(ti, ignored -> new ArrayList());
                collection.add(in.readString());
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.executionPhaseId);
        out.writeVInt(this.executionNodes.size());
        for (String string : this.executionNodes) {
            out.writeString(string);
        }
        out.writeVInt(this.bases.size());
        for (Map.Entry entry : this.bases.entrySet()) {
            out.writeString((String)entry.getKey());
            out.writeVInt((Integer)entry.getValue());
        }
        out.writeVInt(this.fetchRefs.size());
        for (Reference reference : this.fetchRefs) {
            Reference.toStream(out, reference);
        }
        out.writeVInt(this.tableIndices.size());
        for (Map.Entry entry : this.tableIndices.entrySet()) {
            ((RelationName)entry.getKey()).writeTo(out);
            out.writeVInt(((Collection)entry.getValue()).size());
            for (String s : (Collection)entry.getValue()) {
                out.writeString(s);
            }
        }
    }

    public Map<RelationName, Collection<String>> tableIndices() {
        return this.tableIndices;
    }

    public TreeMap<String, Integer> bases() {
        return this.bases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchPhase that = (FetchPhase)o;
        return this.executionPhaseId == that.executionPhaseId && Objects.equals(this.bases, that.bases) && Objects.equals(this.tableIndices, that.tableIndices) && Objects.equals(this.fetchRefs, that.fetchRefs) && Objects.equals(this.executionNodes, that.executionNodes);
    }

    public int hashCode() {
        return Objects.hash(this.bases, this.tableIndices, this.fetchRefs, this.executionPhaseId, this.executionNodes);
    }

    public String toString() {
        return "FetchPhase{bases=" + String.valueOf(this.bases) + ", executionNodes=" + String.valueOf(this.executionNodes) + ", executionPhaseId=" + this.executionPhaseId + ", fetchRefs=" + String.valueOf(this.fetchRefs) + ", tableIndices=" + String.valueOf(this.tableIndices) + "}";
    }

    @Override
    public Streamer<?>[] getStreamers() {
        throw new UnsupportedOperationException("FetchPhase has no streamers");
    }
}

