/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.common.collections.Iterables;
import io.crate.execution.dsl.phases.AbstractProjectionsPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.phases.UpstreamPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.sql.tree.JoinType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public abstract class JoinPhase
extends AbstractProjectionsPhase
implements UpstreamPhase {
    private final Collection<String> executionNodes;
    private final int numLeftOutputs;
    private final int numRightOutputs;
    private final MergePhase leftMergePhase;
    private final MergePhase rightMergePhase;
    protected final JoinType joinType;
    @Nullable
    private final Symbol joinCondition;
    private DistributionInfo distributionInfo = DistributionInfo.DEFAULT_BROADCAST;

    JoinPhase(UUID jobId, int executionNodeId, String name, List<Projection> projections, @Nullable MergePhase leftMergePhase, @Nullable MergePhase rightMergePhase, int numLeftOutputs, int numRightOutputs, Collection<String> executionNodes, JoinType joinType, @Nullable Symbol joinCondition) {
        super(jobId, executionNodeId, name, projections);
        Projection lastProjection = (Projection)Iterables.getLast(projections, null);
        assert (lastProjection != null) : "lastProjection must not be null";
        assert (joinCondition == null || !joinCondition.any(Symbol.IS_COLUMN)) : "joinCondition must not contain columns: " + String.valueOf(joinCondition);
        this.outputTypes = Symbols.typeView(lastProjection.outputs());
        this.leftMergePhase = leftMergePhase;
        this.rightMergePhase = rightMergePhase;
        this.numLeftOutputs = numLeftOutputs;
        this.numRightOutputs = numRightOutputs;
        this.executionNodes = executionNodes;
        this.joinType = joinType;
        this.joinCondition = joinCondition;
    }

    @Override
    public abstract ExecutionPhase.Type type();

    @Override
    public Collection<String> nodeIds() {
        return Objects.requireNonNullElseGet(this.executionNodes, Set::of);
    }

    @Nullable
    public MergePhase leftMergePhase() {
        return this.leftMergePhase;
    }

    @Nullable
    public MergePhase rightMergePhase() {
        return this.rightMergePhase;
    }

    @Nullable
    public Symbol joinCondition() {
        return this.joinCondition;
    }

    public JoinType joinType() {
        return this.joinType;
    }

    public int numLeftOutputs() {
        return this.numLeftOutputs;
    }

    public int numRightOutputs() {
        return this.numRightOutputs;
    }

    JoinPhase(StreamInput in) throws IOException {
        super(in);
        this.distributionInfo = new DistributionInfo(in);
        int numExecutionNodes = in.readVInt();
        if (numExecutionNodes > 0) {
            this.executionNodes = new HashSet<String>(numExecutionNodes);
            for (int i = 0; i < numExecutionNodes; ++i) {
                this.executionNodes.add(in.readString());
            }
        } else {
            this.executionNodes = null;
        }
        this.leftMergePhase = in.readOptionalWriteable(MergePhase::new);
        this.rightMergePhase = in.readOptionalWriteable(MergePhase::new);
        this.numLeftOutputs = in.readVInt();
        this.numRightOutputs = in.readVInt();
        this.joinCondition = Symbol.nullableFromStream(in);
        this.joinType = JoinType.values()[in.readVInt()];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.distributionInfo.writeTo(out);
        if (this.executionNodes == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.executionNodes.size());
            for (String node : this.executionNodes) {
                out.writeString(node);
            }
        }
        out.writeOptionalWriteable(this.leftMergePhase);
        out.writeOptionalWriteable(this.rightMergePhase);
        out.writeVInt(this.numLeftOutputs);
        out.writeVInt(this.numRightOutputs);
        Symbol.nullableToStream(this.joinCondition, out);
        out.writeVInt(this.joinType.ordinal());
    }

    @Override
    public String toString() {
        return "JoinPhase{executionNodes=" + String.valueOf(this.executionNodes) + ", executionPhaseId=" + this.phaseId() + ", name=" + this.name() + ", joinType=" + String.valueOf(this.joinType) + ", joinCondition=" + String.valueOf(this.joinCondition) + ", outputTypes=" + String.valueOf(this.outputTypes) + ", jobId=" + String.valueOf(this.jobId()) + ", executionNodes=" + String.valueOf(this.executionNodes) + "}";
    }

    @Override
    public DistributionInfo distributionInfo() {
        return this.distributionInfo;
    }

    @Override
    public void distributionInfo(DistributionInfo distributionInfo) {
        this.distributionInfo = distributionInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JoinPhase joinPhase = (JoinPhase)o;
        return this.numLeftOutputs == joinPhase.numLeftOutputs && this.numRightOutputs == joinPhase.numRightOutputs && Objects.equals(this.executionNodes, joinPhase.executionNodes) && Objects.equals(this.leftMergePhase, joinPhase.leftMergePhase) && Objects.equals(this.rightMergePhase, joinPhase.rightMergePhase) && this.joinType == joinPhase.joinType && Objects.equals(this.joinCondition, joinPhase.joinCondition) && Objects.equals(this.distributionInfo, joinPhase.distributionInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.executionNodes, this.numLeftOutputs, this.numRightOutputs, this.leftMergePhase, this.rightMergePhase, this.joinType, this.joinCondition, this.distributionInfo);
    }
}

