/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.common.collections.Lists;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RowGranularity;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class EvalProjection
extends Projection {
    private final List<Symbol> outputs;
    private final RowGranularity granularity;

    @Nullable
    public static EvalProjection castValues(List<DataType<?>> targetTypes, List<Symbol> sources) {
        ArrayList<Symbol> casts = new ArrayList<Symbol>(targetTypes.size());
        boolean requiresCasts = false;
        assert (sources.size() >= targetTypes.size()) : "sources size must be >= targetTypes size";
        for (int i = 0; i < targetTypes.size(); ++i) {
            Symbol source = sources.get(i);
            DataType<?> targetType = targetTypes.get(i);
            InputColumn inputColumn = new InputColumn(i, source.valueType());
            if (targetType.id() == DataTypes.UNDEFINED.id() || targetType.equals(source.valueType())) {
                casts.add(inputColumn);
                continue;
            }
            requiresCasts = true;
            casts.add(inputColumn.cast(targetType, new CastMode[0]));
        }
        return requiresCasts ? new EvalProjection(casts) : null;
    }

    public EvalProjection(List<Symbol> outputs) {
        this(outputs, RowGranularity.CLUSTER);
    }

    public EvalProjection(List<Symbol> outputs, RowGranularity granularity) {
        assert (outputs.stream().noneMatch(s -> s.any(Symbol.IS_COLUMN.or(x -> x instanceof SelectSymbol)))) : "EvalProjection doesn't support Field, Reference or SelectSymbol symbols, got: " + String.valueOf(outputs);
        this.outputs = outputs;
        this.granularity = granularity;
    }

    public EvalProjection(StreamInput in) throws IOException {
        this.outputs = Symbols.fromStream(in);
        this.granularity = in.getVersion().onOrAfter(Version.V_4_5_3) ? RowGranularity.fromStream(in) : RowGranularity.CLUSTER;
    }

    @Override
    public RowGranularity requiredGranularity() {
        return this.granularity;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.EVAL;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitEvalProjection(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Symbols.toStream(this.outputs, out);
        if (out.getVersion().onOrAfter(Version.V_4_5_3)) {
            RowGranularity.toStream(this.granularity, out);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvalProjection that = (EvalProjection)o;
        return this.outputs.equals(that.outputs);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.outputs.hashCode();
        return result;
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put((Object)"type", (Object)"Eval").put((Object)"outputs", (Object)Lists.joinOn((String)", ", this.outputs, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).map();
    }

    public String toString() {
        return "EvalProjection{outputs=" + String.valueOf(this.outputs) + "}";
    }
}

