/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OrderedLimitAndOffsetProjection
extends Projection {
    private final int limit;
    private final int offset;
    private final List<Symbol> outputs;
    private final List<Symbol> orderBy;
    private final boolean[] reverseFlags;
    private final boolean[] nullsFirst;

    public OrderedLimitAndOffsetProjection(int limit, int offset, List<Symbol> outputs, List<Symbol> orderBy, boolean[] reverseFlags, boolean[] nullsFirst) {
        assert (outputs.stream().noneMatch(s -> s.any(Symbol.IS_COLUMN.or(x -> x instanceof SelectSymbol)))) : "OrderedLimitAndOffsetProjection outputs cannot contain Field, Reference or SelectSymbol symbols: " + String.valueOf(outputs);
        assert (orderBy.stream().noneMatch(s -> s.any(Symbol.IS_COLUMN.or(x -> x instanceof SelectSymbol)))) : "OrderedLimitAndOffsetProjection orderBy cannot contain Field, Reference or SelectSymbol symbols: " + String.valueOf(orderBy);
        assert (orderBy.size() == reverseFlags.length) : "reverse flags length does not match orderBy items count";
        assert (orderBy.size() == nullsFirst.length) : "nullsFirst length does not match orderBy items count";
        this.limit = limit;
        this.offset = offset;
        this.outputs = outputs;
        this.orderBy = orderBy;
        this.reverseFlags = reverseFlags;
        this.nullsFirst = nullsFirst;
    }

    public OrderedLimitAndOffsetProjection(StreamInput in) throws IOException {
        this.limit = in.readVInt();
        this.offset = in.readVInt();
        this.outputs = Symbols.fromStream(in);
        int numOrderBy = in.readVInt();
        if (numOrderBy == 0) {
            this.orderBy = Collections.emptyList();
            this.reverseFlags = new boolean[0];
            this.nullsFirst = new boolean[0];
        } else {
            this.orderBy = new ArrayList<Symbol>(numOrderBy);
            this.reverseFlags = new boolean[numOrderBy];
            this.nullsFirst = new boolean[numOrderBy];
            for (int i = 0; i < numOrderBy; ++i) {
                this.orderBy.add(Symbol.fromStream(in));
                this.reverseFlags[i] = in.readBoolean();
                this.nullsFirst[i] = in.readBoolean();
            }
        }
    }

    public List<Symbol> orderBy() {
        return this.orderBy;
    }

    public int limit() {
        return this.limit;
    }

    public int offset() {
        return this.offset;
    }

    public boolean[] reverseFlags() {
        return this.reverseFlags;
    }

    public boolean[] nullsFirst() {
        return this.nullsFirst;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.LIMITANDOFFSET_ORDERED;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitOrderedLimitAndOffset(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.limit);
        out.writeVInt(this.offset);
        Symbols.toStream(this.outputs, out);
        out.writeVInt(this.orderBy.size());
        for (int i = 0; i < this.orderBy.size(); ++i) {
            Symbol.toStream(this.orderBy.get(i), out);
            out.writeBoolean(this.reverseFlags[i]);
            out.writeBoolean(this.nullsFirst[i]);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderedLimitAndOffsetProjection that = (OrderedLimitAndOffsetProjection)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (!this.outputs.equals(that.outputs)) {
            return false;
        }
        if (!this.orderBy.equals(that.orderBy)) {
            return false;
        }
        if (!Arrays.equals(this.reverseFlags, that.reverseFlags)) {
            return false;
        }
        return Arrays.equals(this.nullsFirst, that.nullsFirst);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.limit;
        result = 31 * result + this.offset;
        result = 31 * result + this.outputs.hashCode();
        result = 31 * result + this.orderBy.hashCode();
        result = 31 * result + Arrays.hashCode(this.reverseFlags);
        result = 31 * result + Arrays.hashCode(this.nullsFirst);
        return result;
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put((Object)"type", (Object)"OrderLimitAndOffset").put((Object)"limit", (Object)this.limit).put((Object)"offset", (Object)this.offset).put((Object)"outputs", (Object)Lists.joinOn((String)", ", this.outputs, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).put((Object)"orderBy", (Object)OrderBy.explainRepresentation(new StringBuilder("["), this.orderBy, this.reverseFlags, this.nullsFirst, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)()).append("]").toString()).map();
    }
}

