/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation;

import io.crate.common.TriConsumer;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.BinaryDocValueAggregator;
import io.crate.execution.engine.aggregation.impl.templates.SortedNumericDocValueAggregator;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.types.DataType;
import io.crate.types.NumericType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.jetbrains.annotations.Nullable;

public abstract class AggregationFunction<TPartial, TFinal>
implements FunctionImplementation {
    @Nullable
    public abstract TPartial newState(RamAccounting var1, Version var2, MemoryManager var3);

    public abstract TPartial iterate(RamAccounting var1, MemoryManager var2, TPartial var3, Input<?> ... var4) throws CircuitBreakingException;

    public abstract TPartial reduce(RamAccounting var1, TPartial var2, TPartial var3);

    public abstract TFinal terminatePartial(RamAccounting var1, TPartial var2);

    public abstract DataType<?> partialType();

    public AggregationFunction<?, TFinal> optimizeForExecutionAsWindowFunction() {
        return this;
    }

    public boolean isRemovableCumulative() {
        return false;
    }

    public TPartial removeFromAggregatedState(RamAccounting ramAccounting, TPartial previousAggState, Input<?>[] stateToRemove) {
        throw new UnsupportedOperationException("Cannot remove state from the aggregated state as the function is not removable cumulative");
    }

    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        return null;
    }

    protected Reference getAggReference(List<Reference> aggregationReferences) {
        if (aggregationReferences.isEmpty()) {
            return null;
        }
        Reference reference = aggregationReferences.getFirst();
        if (reference == null) {
            return null;
        }
        if (!reference.hasDocValues() || reference.granularity() != RowGranularity.DOC) {
            return null;
        }
        return reference;
    }

    protected DocValueAggregator<?> getNumericDocValueAggregator(List<Reference> aggregationReferences, TriConsumer<RamAccounting, TPartial, BigDecimal> applyToState) {
        Reference reference = this.getAggReference(aggregationReferences);
        if (reference == null) {
            return null;
        }
        DataType<?> valueType = reference.valueType();
        if (valueType.id() != 22) {
            return null;
        }
        NumericType numericType = (NumericType)valueType;
        Integer precision = numericType.numericPrecision();
        Integer scale = numericType.scale();
        if (precision == null || scale == null) {
            throw new UnsupportedOperationException("NUMERIC type requires precision and scale to support aggregation");
        }
        if (precision <= 18) {
            return new SortedNumericDocValueAggregator<Object>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> this.newState((RamAccounting)ramAccounting, (Version)version, (MemoryManager)memoryManager), (ramAccounting, values, state) -> {
                long docValue = values.nextValue();
                applyToState.accept(ramAccounting, state, (Object)BigDecimal.valueOf(docValue, scale));
            });
        }
        return new BinaryDocValueAggregator<Object>(reference.storageIdent(), (ramAccounting, memoryManager, version) -> this.newState((RamAccounting)ramAccounting, (Version)version, (MemoryManager)memoryManager), (ramAccounting, values, state) -> {
            BytesRef bytesRef = values.lookupOrd(values.nextOrd());
            BigInteger bigInteger = NumericUtils.sortableBytesToBigInt((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)bytesRef.length);
            applyToState.accept(ramAccounting, state, (Object)new BigDecimal(bigInteger, scale));
        });
    }
}

