/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.Streamer;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.statistics.NumericVariance;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public abstract class NumericStandardDeviationAggregation<V extends NumericVariance>
extends AggregationFunction<V, BigDecimal> {
    private final Signature signature;
    private final BoundSignature boundSignature;

    public NumericStandardDeviationAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public V iterate(RamAccounting ramAccounting, MemoryManager memoryManager, V state, Input<?> ... args) throws CircuitBreakingException {
        BigDecimal value;
        if (state != null && (value = (BigDecimal)args[0].value()) != null) {
            long sizeBefore = ((NumericVariance)state).size();
            ((NumericVariance)state).increment(value);
            long sizeAfter = ((NumericVariance)state).size();
            ramAccounting.addBytes(sizeBefore - sizeAfter);
        }
        return state;
    }

    @Override
    public V reduce(RamAccounting ramAccounting, V state1, V state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        ((NumericVariance)state1).merge((NumericVariance)state2);
        return state1;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public V removeFromAggregatedState(RamAccounting ramAccounting, V previousAggState, Input<?>[] stateToRemove) {
        BigDecimal value;
        if (previousAggState != null && (value = (BigDecimal)stateToRemove[0].value()) != null) {
            long sizeBefore = ((NumericVariance)previousAggState).size();
            ((NumericVariance)previousAggState).decrement(value);
            long sizeAfter = ((NumericVariance)previousAggState).size();
            ramAccounting.addBytes(sizeBefore - sizeAfter);
        }
        return previousAggState;
    }

    @Override
    public BigDecimal terminatePartial(RamAccounting ramAccounting, V state) {
        return ((NumericVariance)state).result();
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        return this.getNumericDocValueAggregator(aggregationReferences, (ramAccounting, state, bigDecimal) -> {
            long sizeBefore = state.size();
            state.increment((BigDecimal)bigDecimal);
            long sizeAfter = state.size();
            ramAccounting.addBytes(sizeBefore - sizeAfter);
        });
    }

    public static abstract class StdDevNumericStateType<V extends NumericVariance>
    extends DataType<V>
    implements Streamer<V> {
        @Override
        public DataType.Precedence precedence() {
            return DataType.Precedence.CUSTOM;
        }

        @Override
        public Streamer<V> streamer() {
            return this;
        }

        @Override
        public V sanitizeValue(Object value) {
            return (V)((NumericVariance)value);
        }

        @Override
        public int compare(V val1, V val2) {
            return ((NumericVariance)val1).compareTo((NumericVariance)val2);
        }

        @Override
        public void writeValueTo(StreamOutput out, V v) throws IOException {
            ((NumericVariance)v).writeTo(out);
        }

        @Override
        public long valueBytes(V value) {
            return value != null ? ((NumericVariance)value).size() : 0L;
        }
    }
}

