/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.impl.NumericStandardDeviationAggregation;
import io.crate.execution.engine.aggregation.statistics.NumericStandardDeviationPop;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.jetbrains.annotations.Nullable;

public class NumericStandardDeviationPopAggregation
extends NumericStandardDeviationAggregation<NumericStandardDeviationPop> {
    public static final String NAME = "stddev_pop";

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), NumericStandardDeviationPopAggregation::new);
    }

    public NumericStandardDeviationPopAggregation(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public DataType<?> partialType() {
        return new NumericStdDevPopStateType();
    }

    @Override
    @Nullable
    public NumericStandardDeviationPop newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        if (minNodeInCluster.before(Version.V_6_0_0)) {
            throw new IllegalStateException("Cannot use 'stddev_pop' aggregation on NUMERIC values until all nodes are upgraded to 6.0");
        }
        NumericStandardDeviationPop newState = new NumericStandardDeviationPop();
        ramAccounting.addBytes(newState.size());
        return newState;
    }

    static {
        DataTypes.register(8195, streamInput -> NumericStdDevPopStateType.INSTANCE);
    }

    public static class NumericStdDevPopStateType
    extends NumericStandardDeviationAggregation.StdDevNumericStateType<NumericStandardDeviationPop> {
        public static final NumericStdDevPopStateType INSTANCE = new NumericStdDevPopStateType();
        public static final int ID = 8195;

        @Override
        public int id() {
            return 8195;
        }

        @Override
        public String getName() {
            return "stddev_sampl_numeric_state";
        }

        @Override
        public NumericStandardDeviationPop readValueFrom(StreamInput in) throws IOException {
            return new NumericStandardDeviationPop(in);
        }
    }
}

