/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.impl.NumericStandardDeviationAggregation;
import io.crate.execution.engine.aggregation.statistics.NumericStandardDeviationSamp;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.jetbrains.annotations.Nullable;

public class NumericStandardDeviationSampAggregation
extends NumericStandardDeviationAggregation<NumericStandardDeviationSamp> {
    public static final List<String> NAMES = List.of("stddev_samp", "stddev");

    public static void register(Functions.Builder builder) {
        for (String name : NAMES) {
            builder.add(Signature.builder(name, FunctionType.AGGREGATE).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), NumericStandardDeviationSampAggregation::new);
        }
    }

    public NumericStandardDeviationSampAggregation(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public DataType<?> partialType() {
        return new NumericStdDevSampStateType();
    }

    @Override
    @Nullable
    public NumericStandardDeviationSamp newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        if (minNodeInCluster.before(Version.V_6_0_0)) {
            throw new IllegalStateException("Cannot use '" + NAMES.getFirst() + "' aggregation on NUMERIC values until all nodes are upgraded to 6.0");
        }
        NumericStandardDeviationSamp newState = new NumericStandardDeviationSamp();
        ramAccounting.addBytes(newState.size());
        return newState;
    }

    static {
        DataTypes.register(8194, streamInput -> NumericStdDevSampStateType.INSTANCE);
    }

    public static class NumericStdDevSampStateType
    extends NumericStandardDeviationAggregation.StdDevNumericStateType<NumericStandardDeviationSamp> {
        public static final NumericStdDevSampStateType INSTANCE = new NumericStdDevSampStateType();
        public static final int ID = 8194;

        @Override
        public int id() {
            return 8194;
        }

        @Override
        public String getName() {
            return "stddev_sampl_numeric_state";
        }

        @Override
        public NumericStandardDeviationSamp readValueFrom(StreamInput in) throws IOException {
            return new NumericStandardDeviationSamp(in);
        }
    }
}

