/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import com.tdunning.math.stats.TDigest;
import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.impl.TDigestState;
import io.crate.execution.engine.aggregation.impl.TDigestStateType;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.jetbrains.annotations.Nullable;

class PercentileAggregation
extends AggregationFunction<TDigestState, Object> {
    public static final String NAME = "percentile";
    private final Signature signature;
    private final BoundSignature boundSignature;

    public static void register(Functions.Builder builder) {
        for (DataType<? extends Number> supportedType : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), PercentileAggregation::new);
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature(), DataTypes.DOUBLE_ARRAY.getTypeSignature()).returnType(DataTypes.DOUBLE_ARRAY.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), PercentileAggregation::new);
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), PercentileAggregation::new);
            builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(supportedType.getTypeSignature(), DataTypes.DOUBLE_ARRAY.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).returnType(DataTypes.DOUBLE_ARRAY.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), PercentileAggregation::new);
        }
    }

    private PercentileAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @Nullable
    public TDigestState newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes(TDigestState.SHALLOW_SIZE);
        return TDigestState.createEmptyState();
    }

    @Override
    public TDigestState iterate(RamAccounting ramAccounting, MemoryManager memoryManager, TDigestState state, Input<?> ... args) throws CircuitBreakingException {
        Double value;
        if (state.isEmpty()) {
            Object fractionValue = args[1].value();
            if (args.length > 2) {
                Double compression = DataTypes.DOUBLE.sanitizeValue(args[2].value());
                state = new TDigestState(compression, new double[0]);
            }
            this.initState(state, fractionValue, ramAccounting);
        }
        if ((value = DataTypes.DOUBLE.sanitizeValue(args[0].value())) != null) {
            int sizeBefore = state.byteSize();
            state.add(value);
            int sizeDelta = state.byteSize() - sizeBefore;
            if (sizeDelta > 0) {
                ramAccounting.addBytes((long)sizeDelta);
            }
        }
        return state;
    }

    private void initState(TDigestState state, Object argValue, RamAccounting ramAccounting) {
        if (argValue != null) {
            if (argValue instanceof List) {
                List values = (List)argValue;
                if (values.isEmpty() || values.contains(null)) {
                    throw new IllegalArgumentException("no fraction value specified");
                }
                ramAccounting.addBytes((long)values.size() * 8L);
                state.fractions(PercentileAggregation.toDoubleArray(values));
            } else {
                ramAccounting.addBytes(8L);
                state.fractions(new double[]{DataTypes.DOUBLE.sanitizeValue(argValue)});
            }
        }
    }

    private static double[] toDoubleArray(List<?> values) {
        double[] result = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            result[i] = DataTypes.DOUBLE.sanitizeValue(values.get(i));
        }
        return result;
    }

    @Override
    public TDigestState reduce(RamAccounting ramAccounting, TDigestState state1, TDigestState state2) {
        if (state1.isEmpty()) {
            return state2;
        }
        if (!state2.isEmpty()) {
            state1.add((TDigest)state2);
        }
        return state1;
    }

    @Override
    @Nullable
    public Object terminatePartial(RamAccounting ramAccounting, TDigestState state) {
        if (state.isEmpty()) {
            return null;
        }
        ArrayList<Double> percentiles = new ArrayList<Double>(state.fractions().length);
        if (this.boundSignature.returnType() instanceof ArrayType) {
            for (int i = 0; i < state.fractions().length; ++i) {
                double percentile = state.quantile(state.fractions()[i]);
                if (Double.isNaN(percentile)) {
                    percentiles.add(null);
                    continue;
                }
                percentiles.add(percentile);
            }
            return percentiles;
        }
        double percentile = state.quantile(state.fractions()[0]);
        if (Double.isNaN(percentile)) {
            return null;
        }
        return percentile;
    }

    @Override
    public DataType<?> partialType() {
        return TDigestStateType.INSTANCE;
    }

    static {
        DataTypes.register(5120, streamInput -> TDigestStateType.INSTANCE);
    }
}

