/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl.average.numeric;

import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.average.AverageAggregation;
import io.crate.execution.engine.aggregation.impl.average.numeric.NumericAverageState;
import io.crate.execution.engine.aggregation.impl.average.numeric.NumericAverageStateType;
import io.crate.execution.engine.aggregation.impl.util.BigDecimalValueWrapper;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.NumericType;
import java.math.BigDecimal;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.jetbrains.annotations.Nullable;

public class NumericAverageAggregation
extends AggregationFunction<NumericAverageState<?>, BigDecimal> {
    private final Signature signature;
    private final BoundSignature boundSignature;
    private final DataType<BigDecimal> returnType;

    public static void register(Functions.Builder builder) {
        for (String functionName : AverageAggregation.NAMES) {
            builder.add(Signature.builder(functionName, FunctionType.AGGREGATE).argumentTypes(DataTypes.NUMERIC.getTypeSignature()).returnType(DataTypes.NUMERIC.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), NumericAverageAggregation::new);
        }
    }

    private NumericAverageAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        DataType<?> argumentType = boundSignature.argTypes().get(0);
        this.returnType = argumentType instanceof NumericAverageStateType ? boundSignature.returnType() : argumentType;
    }

    @Override
    @Nullable
    public NumericAverageState<?> newState(RamAccounting ramAccounting, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes(NumericAverageStateType.INIT_SIZE);
        return new NumericAverageState<BigDecimalValueWrapper>(new BigDecimalValueWrapper(BigDecimal.ZERO), 0L);
    }

    @Override
    public NumericAverageState<?> iterate(RamAccounting ramAccounting, MemoryManager memoryManager, NumericAverageState<?> state, Input<?> ... args) throws CircuitBreakingException {
        BigDecimal value;
        if (state != null && (value = this.returnType.implicitCast(args[0].value())) != null) {
            BigDecimal newValue = state.sum.value().add(value);
            ramAccounting.addBytes(NumericType.sizeDiff(newValue, state.sum.value()));
            state.sum.setValue(newValue);
            ++state.count;
        }
        return state;
    }

    @Override
    public NumericAverageState<?> reduce(RamAccounting ramAccounting, NumericAverageState<?> state1, NumericAverageState<?> state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        BigDecimal newValue = state1.sum.value().add(state2.sum.value());
        ramAccounting.addBytes(NumericType.sizeDiff(newValue, state1.sum.value()));
        state1.sum.setValue(newValue);
        state1.count += state2.count;
        return state1;
    }

    @Override
    public BigDecimal terminatePartial(RamAccounting ramAccounting, NumericAverageState<?> state) {
        return state.value();
    }

    @Override
    public DataType<?> partialType() {
        return NumericAverageStateType.INSTANCE;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public NumericAverageState<?> removeFromAggregatedState(RamAccounting ramAccounting, NumericAverageState<?> previousAggState, Input<?>[] stateToRemove) {
        BigDecimal value;
        if (previousAggState != null && (value = this.returnType.implicitCast(stateToRemove[0].value())) != null) {
            BigDecimal newValue = previousAggState.sum.value().subtract(value);
            ramAccounting.addBytes(NumericType.sizeDiff(newValue, previousAggState.sum.value()));
            --previousAggState.count;
            previousAggState.sum.setValue(newValue);
        }
        return previousAggState;
    }

    @Override
    @Nullable
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        return this.getNumericDocValueAggregator(aggregationReferences, (ramAccounting, state, bigDecimal) -> {
            BigDecimal newValue = state.sum.value().add((BigDecimal)bigDecimal);
            ramAccounting.addBytes(NumericType.sizeDiff(newValue, state.sum.value()));
            state.sum.setValue(newValue);
            ++state.count;
        });
    }

    static {
        DataTypes.register(1026, streamInput -> NumericAverageStateType.INSTANCE);
    }
}

