/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.analyze.OrderBy;
import io.crate.analyze.WhereClause;
import io.crate.common.collections.Lists;
import io.crate.data.Buckets;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.ValueAndInputRow;
import io.crate.execution.engine.sort.OrderingByPosition;
import io.crate.expression.InputCondition;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.TransactionContext;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public final class RowsTransformer {
    public static Iterable<Row> toRowsIterable(TransactionContext txnCtx, InputFactory inputFactory, ReferenceResolver<?> referenceResolver, RoutedCollectPhase collectPhase, Iterable<?> iterable) {
        return RowsTransformer.toRowsIterable(txnCtx, inputFactory, referenceResolver, collectPhase, iterable, true);
    }

    public static Iterable<Row> toRowsIterable(TransactionContext txnCtx, InputFactory inputFactory, ReferenceResolver<?> referenceResolver, RoutedCollectPhase collectPhase, Iterable<?> iterable, boolean sort) {
        if (!WhereClause.canMatch(collectPhase.where())) {
            return Collections.emptyList();
        }
        InputFactory.Context<?> ctx = inputFactory.ctxForRefs(txnCtx, referenceResolver);
        ctx.add(collectPhase.toCollect());
        OrderBy orderBy = collectPhase.orderBy();
        if (orderBy != null) {
            for (Symbol symbol : orderBy.orderBySymbols()) {
                ctx.add(symbol);
            }
        }
        ValueAndInputRow inputRow = new ValueAndInputRow(ctx.topLevelInputs(), ctx.expressions());
        assert (DataTypes.BOOLEAN.equals(collectPhase.where().valueType())) : "whereClause.query() must be of type " + String.valueOf(DataTypes.BOOLEAN);
        Predicate<Row> predicate = InputCondition.asPredicate(ctx.add(collectPhase.where()));
        if (!sort || orderBy == null) {
            return () -> StreamSupport.stream(iterable.spliterator(), false).map(inputRow).filter(predicate).iterator();
        }
        ArrayList<Object[]> items = new ArrayList<Object[]>();
        for (Object item : iterable) {
            Row row = inputRow.apply(item);
            if (!predicate.test(row)) continue;
            items.add(row.materialize());
        }
        items.sort(OrderingByPosition.arrayOrdering(collectPhase));
        return Lists.mapLazy(items, (Function)Buckets.arrayToSharedRow());
    }

    public static Iterable<Row> sortRows(Iterable<Object[]> rows, RoutedCollectPhase collectPhase) {
        List objects = Lists.of(rows);
        Comparator<Object[]> ordering = OrderingByPosition.arrayOrdering(collectPhase);
        objects.sort(ordering);
        return Lists.mapLazy((List)objects, (Function)Buckets.arrayToSharedRow());
    }
}

