/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.analyze.WhereClause;
import io.crate.common.collections.Lists;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.execution.engine.collect.collectors.NodeStats;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.execution.engine.collect.stats.NodeStatsAction;
import io.crate.execution.engine.collect.stats.NodeStatsRequest;
import io.crate.execution.engine.collect.stats.NodeStatsResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.expression.InputFactory;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.reference.sys.node.NodeStatsContext;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.MapBackedRefResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.expressions.RowCollectExpressionFactory;
import io.crate.metadata.sys.SysNodesTableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.node.Node;

@Singleton
public class NodeStatsCollectSource
implements CollectSource {
    private final ActionExecutor<NodeStatsRequest, NodeStatsResponse> nodeStatsAction = req -> node.client().execute(NodeStatsAction.INSTANCE, req);
    private final ClusterService clusterService;
    private final NodeContext nodeCtx;
    private final InputFactory inputFactory;

    @Inject
    public NodeStatsCollectSource(Node node, ClusterService clusterService, NodeContext nodeCtx) {
        this.clusterService = clusterService;
        this.inputFactory = new InputFactory(nodeCtx);
        this.nodeCtx = nodeCtx;
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase phase, CollectTask collectTask, boolean supportMoveToStart) {
        RoutedCollectPhase collectPhase = (RoutedCollectPhase)phase;
        if (!WhereClause.canMatch(collectPhase.where())) {
            return CompletableFuture.completedFuture(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL));
        }
        Collection<DiscoveryNode> nodes = NodeStatsCollectSource.filterNodes(Lists.of((Iterable)this.clusterService.state().nodes()), collectPhase.where(), this.nodeCtx);
        if (nodes.isEmpty()) {
            return CompletableFuture.completedFuture(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL));
        }
        return CompletableFuture.completedFuture(NodeStats.newInstance(this.nodeStatsAction, collectPhase, nodes, txnCtx, this.inputFactory));
    }

    static Collection<DiscoveryNode> filterNodes(Collection<DiscoveryNode> nodes, Symbol predicate, NodeContext nodeCtx) {
        Map<ColumnIdent, RowCollectExpressionFactory<NodeStatsContext>> expressions = SysNodesTableInfo.INSTANCE.expressions();
        NestableCollectExpression<NodeStatsContext, ?> nameExpr = expressions.get(SysNodesTableInfo.Columns.NAME).create();
        NestableCollectExpression<NodeStatsContext, ?> idExpr = expressions.get(SysNodesTableInfo.Columns.ID).create();
        MapBackedRefResolver referenceResolver = new MapBackedRefResolver(Map.of(SysNodesTableInfo.Columns.NAME, nameExpr, SysNodesTableInfo.Columns.ID, idExpr));
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.DOC, referenceResolver, null);
        ArrayList<DiscoveryNode> newNodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode node : nodes) {
            String nodeId = node.getId();
            NodeStatsContext statsContext = new NodeStatsContext(nodeId, node.getName());
            nameExpr.setNextRow(statsContext);
            idExpr.setNextRow(statsContext);
            Symbol normalized = normalizer.normalize(predicate, CoordinatorTxnCtx.systemTransactionContext());
            if (normalized.equals(predicate)) {
                return nodes;
            }
            if (!WhereClause.canMatch(normalized)) continue;
            newNodes.add(node);
        }
        return newNodes;
    }
}

