/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.sources.CollectSource;
import io.crate.execution.engine.pipeline.ProjectorFactory;
import io.crate.execution.engine.pipeline.Projectors;
import io.crate.metadata.TransactionContext;
import java.util.concurrent.CompletableFuture;

public class ProjectorSetupCollectSource
implements CollectSource {
    private final CollectSource sourceDelegate;
    private final ProjectorFactory projectorFactory;

    public ProjectorSetupCollectSource(CollectSource sourceDelegate, ProjectorFactory projectorFactory) {
        this.sourceDelegate = sourceDelegate;
        this.projectorFactory = projectorFactory;
    }

    @Override
    public CompletableFuture<BatchIterator<Row>> getIterator(TransactionContext txnCtx, CollectPhase collectPhase, CollectTask collectTask, boolean supportMoveToStart) {
        CompletableFuture<BatchIterator<Row>> futureSourceIterator = this.sourceDelegate.getIterator(txnCtx, collectPhase, collectTask, supportMoveToStart);
        return futureSourceIterator.thenApply(it -> Projectors.wrap(collectPhase.projections(), collectPhase.jobId(), collectTask.txnCtx(), collectTask.getRamAccounting(), collectTask.memoryManager(), this.projectorFactory, (BatchIterator<Row>)it));
    }
}

