/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.common.annotations.ThreadSafe;
import io.crate.execution.engine.collect.stats.LogSink;
import io.crate.execution.engine.collect.stats.NoopLogSink;
import io.crate.expression.reference.sys.job.JobContext;
import io.crate.expression.reference.sys.job.JobContextLog;
import io.crate.expression.reference.sys.operation.OperationContext;
import io.crate.expression.reference.sys.operation.OperationContextLog;
import io.crate.metadata.sys.ClassifiedMetrics;
import io.crate.metadata.sys.MetricsView;
import io.crate.planner.Plan;
import io.crate.planner.operators.StatementClassifier;
import io.crate.role.Role;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ThreadSafe
public class JobsLogs {
    private final Map<UUID, JobContext> jobsTable = new ConcurrentHashMap<UUID, JobContext>();
    private final Map<OperationId, OperationContext> operationsTable = new ConcurrentHashMap<OperationId, OperationContext>();
    private LogSink<JobContextLog> jobsLog = NoopLogSink.instance();
    private LogSink<OperationContextLog> operationsLog = NoopLogSink.instance();
    private final StampedLock jobsLogLock = new StampedLock();
    private final StampedLock operationsLogRWLock = new StampedLock();
    private final LongAdder activeRequests = new LongAdder();
    private final BooleanSupplier enabled;
    private final ClassifiedMetrics classifiedMetrics = new ClassifiedMetrics();

    public JobsLogs(BooleanSupplier enabled) {
        this.enabled = enabled;
    }

    private boolean isEnabled() {
        return this.enabled.getAsBoolean();
    }

    public void logExecutionStart(UUID jobId, String statement, Role user, StatementClassifier.Classification classification) {
        this.activeRequests.increment();
        if (!this.isEnabled()) {
            return;
        }
        this.jobsTable.put(jobId, new JobContext(jobId, statement, System.currentTimeMillis(), user, classification));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logExecutionEnd(UUID jobId, @Nullable String errorMessage) {
        this.activeRequests.decrement();
        JobContext jobContext = this.jobsTable.remove(jobId);
        if (!this.isEnabled() || jobContext == null) {
            return;
        }
        JobContextLog jobContextLog = new JobContextLog(jobContext, errorMessage);
        this.recordMetrics(jobContextLog);
        long stamp = this.jobsLogLock.readLock();
        try {
            this.jobsLog.add(jobContextLog);
        }
        finally {
            this.jobsLogLock.unlockRead(stamp);
        }
    }

    private void recordMetrics(JobContextLog log) {
        StatementClassifier.Classification classification = log.classification();
        assert (classification != null) : "A job must have a classification";
        if (log.errorMessage() == null) {
            this.classifiedMetrics.recordValue(classification, log.ended() - log.started());
        } else {
            this.classifiedMetrics.recordFailedExecution(classification, log.ended() - log.started());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logPreExecutionFailure(UUID jobId, String stmt, String errorMessage, Role user) {
        JobContextLog jobContextLog = new JobContextLog(new JobContext(jobId, stmt, System.currentTimeMillis(), user, new StatementClassifier.Classification(Plan.StatementType.UNDEFINED)), errorMessage);
        long stamp = this.jobsLogLock.readLock();
        try {
            this.jobsLog.add(jobContextLog);
        }
        finally {
            this.jobsLogLock.unlockRead(stamp);
        }
        this.recordMetrics(jobContextLog);
    }

    public void operationStarted(int operationId, UUID jobId, String name, LongSupplier bytesUsed) {
        if (this.isEnabled()) {
            this.operationsTable.put(new OperationId(operationId, jobId), new OperationContext(operationId, jobId, name, System.currentTimeMillis(), bytesUsed));
        }
    }

    public Iterable<MetricsView> metrics() {
        return this.classifiedMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationFinished(int operationId, UUID jobId, @Nullable String errorMessage) {
        if (!this.isEnabled()) {
            return;
        }
        OperationContext operationContext = this.operationsTable.remove(new OperationId(operationId, jobId));
        if (operationContext == null) {
            return;
        }
        OperationContextLog operationContextLog = new OperationContextLog(operationContext, errorMessage);
        long stamp = this.operationsLogRWLock.readLock();
        try {
            this.operationsLog.add(operationContextLog);
        }
        finally {
            this.operationsLogRWLock.unlockRead(stamp);
        }
    }

    public Iterable<JobContext> activeJobs() {
        return this.jobsTable.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<JobContextLog> jobsLog() {
        long stamp = this.jobsLogLock.readLock();
        try {
            LogSink<JobContextLog> logSink = this.jobsLog;
            return logSink;
        }
        finally {
            this.jobsLogLock.unlockRead(stamp);
        }
    }

    public Iterable<OperationContext> activeOperations() {
        return this.operationsTable.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<OperationContextLog> operationsLog() {
        long stamp = this.operationsLogRWLock.readLock();
        try {
            LogSink<OperationContextLog> logSink = this.operationsLog;
            return logSink;
        }
        finally {
            this.operationsLogRWLock.unlockRead(stamp);
        }
    }

    public long activeRequests() {
        return this.activeRequests.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateOperationsLog(LogSink<OperationContextLog> sink) {
        long stamp = this.operationsLogRWLock.writeLock();
        try {
            sink.addAll(this.operationsLog);
            this.operationsLog.close();
            this.operationsLog = sink;
        }
        finally {
            this.operationsLogRWLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void updateJobsLog(LogSink<JobContextLog> sink) {
        long stamp = this.jobsLogLock.writeLock();
        try {
            sink.addAll(this.jobsLog);
            this.jobsLog.close();
            this.jobsLog = sink;
        }
        finally {
            this.jobsLogLock.unlockWrite(stamp);
        }
    }

    void resetMetrics() {
        this.classifiedMetrics.reset();
    }

    public void close() {
        this.jobsLog.close();
        this.operationsLog.close();
    }

    record OperationId(int operationId, UUID jobId) {
    }
}

