/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.stats;

import io.crate.execution.engine.collect.stats.LogSink;
import java.util.Iterator;
import java.util.Queue;

public class QueueSink<T>
implements LogSink<T> {
    private final Queue<T> queue;
    private final Runnable onClose;

    public QueueSink(Queue<T> queue, Runnable onClose) {
        this.queue = queue;
        this.onClose = onClose;
    }

    @Override
    public void add(T item) {
        this.queue.offer(item);
    }

    @Override
    public void addAll(Iterable<T> iterable) {
        for (T t : iterable) {
            this.add(t);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public void close() {
        this.onClose.run();
    }
}

