/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.Streamer;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.engine.distribution.BroadcastingBucketBuilder;
import io.crate.execution.engine.distribution.DistributedResultAction;
import io.crate.execution.engine.distribution.DistributedResultRequest;
import io.crate.execution.engine.distribution.DistributedResultResponse;
import io.crate.execution.engine.distribution.DistributingConsumer;
import io.crate.execution.engine.distribution.ModuloBucketBuilder;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.NodeRequest;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.distribution.DistributionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class DistributingConsumerFactory {
    private static final String RESPONSE_EXECUTOR_NAME = "search";
    private final ClusterService clusterService;
    private final Executor responseExecutor;
    private final ActionExecutor<NodeRequest<DistributedResultRequest>, DistributedResultResponse> distributedResultAction;
    private final ThreadPool threadPool;

    @Inject
    public DistributingConsumerFactory(ClusterService clusterService, ThreadPool threadPool, Node node) {
        this.clusterService = clusterService;
        this.responseExecutor = threadPool.executor(RESPONSE_EXECUTOR_NAME);
        this.distributedResultAction = req -> node.client().execute(DistributedResultAction.INSTANCE, req);
        this.threadPool = threadPool;
    }

    public DistributingConsumer create(NodeOperation nodeOperation, RamAccounting ramAccounting, DistributionInfo distributionInfo, UUID jobId, int pageSize) {
        Streamer<?>[] streamers = nodeOperation.executionPhase().getStreamers();
        assert (!ExecutionPhases.hasDirectResponseDownstream(nodeOperation.downstreamNodes())) : "trying to build a DistributingDownstream but nodeOperation has a directResponse downstream";
        assert (nodeOperation.downstreamNodes().size() > 0) : "must have at least one downstream";
        byte phaseInputId = nodeOperation.downstreamExecutionPhaseInputId();
        int bucketIdx = this.getBucketIdx(nodeOperation.executionPhase().nodeIds(), phaseInputId);
        return new DistributingConsumer(this.responseExecutor, jobId, switch (distributionInfo.distributionType()) {
            case DistributionType.MODULO -> {
                if (nodeOperation.downstreamNodes().size() == 1) {
                    yield new BroadcastingBucketBuilder(streamers, nodeOperation.downstreamNodes().size(), ramAccounting);
                }
                yield new ModuloBucketBuilder(streamers, nodeOperation.downstreamNodes().size(), distributionInfo.distributeByColumn(), ramAccounting);
            }
            case DistributionType.BROADCAST -> new BroadcastingBucketBuilder(streamers, nodeOperation.downstreamNodes().size(), ramAccounting);
            default -> throw new UnsupportedOperationException("Can't handle distributionInfo: " + String.valueOf(distributionInfo));
        }, nodeOperation.downstreamExecutionPhaseId(), phaseInputId, bucketIdx, nodeOperation.downstreamNodes(), this.distributedResultAction, pageSize, this.threadPool);
    }

    private int getBucketIdx(Collection<String> nodeIds, byte phaseInputId) {
        ArrayList<String> server = new ArrayList<String>(nodeIds);
        server.sort(null);
        int nodeId = Math.max(server.indexOf(this.clusterService.localNode().getId()), 0);
        return nodeId | phaseInputId << 24;
    }
}

