/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.Streamer;
import io.crate.data.Bucket;
import io.crate.data.Row;
import io.crate.data.RowN;
import io.crate.data.breaker.RamAccounting;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamBucket
implements Bucket,
Writeable {
    private Streamer<?>[] streamers;
    private int size = -1;
    private BytesReference bytes;

    public StreamBucket(@Nullable Streamer<?>[] streamers) {
        assert (StreamBucket.validStreamers(streamers)) : "streamers must not be null and they shouldn't be of undefinedType";
        this.streamers = streamers;
    }

    public int size() {
        return this.size;
    }

    public void streamers(Streamer<?>[] streamers) {
        assert (StreamBucket.validStreamers(streamers)) : "streamers must not be null and they shouldn't be of undefinedType";
        this.streamers = streamers;
    }

    private static boolean validStreamers(Streamer<?>[] streamers) {
        if (streamers == null) {
            return true;
        }
        for (Streamer<?> streamer : streamers) {
            if (streamer != null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Iterator<Row> iterator() {
        if (this.size < 1) {
            return Collections.emptyIterator();
        }
        assert (this.streamers != null) : "streamers must not be null";
        try {
            return new RowIterator(this.bytes.streamInput(), this.streamers, this.size);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public StreamBucket(StreamInput in, Streamer<?>[] streamers) throws IOException {
        this(in);
        this.streamers = streamers;
    }

    public StreamBucket(StreamInput in) throws IOException {
        this.size = in.readVInt();
        if (this.size > 0) {
            this.bytes = in.readBytesReference();
        }
    }

    public String toString() {
        return "StreamBucket{size=" + this.size + "}";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (this.size > -1) : "size must be > -1";
        out.writeVInt(this.size);
        if (this.size > 0) {
            out.writeBytesReference(this.bytes);
        }
    }

    private static class RowIterator
    implements Iterator<Row> {
        private final Streamer<?>[] streamers;
        private final int size;
        private final StreamInput input;
        private final Object[] current;
        private final RowN row;
        private int pos = 0;

        private RowIterator(StreamInput streamInput, Streamer<?>[] streamers, int size) {
            this.streamers = streamers;
            this.size = size;
            this.input = streamInput;
            this.current = new Object[streamers.length];
            this.row = new RowN(this.current);
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.size;
        }

        @Override
        public Row next() {
            for (int c = 0; c < this.streamers.length; ++c) {
                try {
                    this.current[c] = this.streamers[c].readValueFrom(this.input);
                    continue;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ++this.pos;
            return this.row;
        }

        @Override
        public void remove() {
        }
    }

    public static class Builder
    implements Accountable {
        private static final int INITIAL_PAGE_SIZE = 1024;
        private final RamAccounting ramAccounting;
        private final Streamer<?>[] streamers;
        private int size = 0;
        private BytesStreamOutput out;
        private int prevOutSize = 0;

        public Builder(Streamer<?>[] streamers, RamAccounting ramAccounting) {
            this.ramAccounting = Objects.requireNonNull(ramAccounting, "RamAccounting must not be null");
            assert (StreamBucket.validStreamers(streamers)) : "streamers must not be null and they shouldn't be of undefinedType";
            this.streamers = streamers;
            this.out = new BytesStreamOutput(1024);
        }

        public void add(Row row) {
            assert (this.streamers.length == row.numColumns()) : "number of streamer must match row size";
            ++this.size;
            for (int i = 0; i < row.numColumns(); ++i) {
                try {
                    this.streamers[i].writeValueTo(this.out, row.get(i));
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.ramAccounting.addBytes((long)(this.out.size() - this.prevOutSize));
            this.prevOutSize = this.out.size();
        }

        public StreamBucket build() {
            StreamBucket sb = new StreamBucket(this.streamers);
            sb.size = this.size;
            sb.bytes = this.out.bytes();
            return sb;
        }

        public void reset() {
            this.out = new BytesStreamOutput(this.size);
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public long ramBytesUsed() {
            return this.ramAccounting.totalBytes();
        }
    }
}

