/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution.merge;

import io.crate.data.Row;
import io.crate.data.breaker.RowAccounting;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PassThroughPagingIterator;
import io.crate.execution.engine.distribution.merge.PlainSortedMergeIterator;
import io.crate.execution.engine.distribution.merge.RamAccountingPageIterator;
import io.crate.execution.engine.distribution.merge.RecordingSortedMergeIterator;
import io.crate.execution.engine.sort.OrderingByPosition;
import io.crate.planner.PositionalOrderBy;
import io.crate.types.DataType;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public interface PagingIterator<TKey, TRow>
extends Iterator<TRow> {
    public void merge(Iterable<? extends KeyIterable<TKey, TRow>> var1);

    public void finish();

    public TKey exhaustedIterable();

    public Iterable<TRow> repeat();

    public static <TKey> PagingIterator<TKey, Row> create(int numUpstreams, List<? extends DataType<?>> inputTypes, boolean requiresRepeat, @Nullable PositionalOrderBy orderBy, Supplier<RowAccounting<Row>> rowAccountingSupplier) {
        PagingIterator pagingIterator;
        if (numUpstreams == 1 || orderBy == null) {
            pagingIterator = requiresRepeat ? new RamAccountingPageIterator(PassThroughPagingIterator.repeatable(), rowAccountingSupplier.get()) : PassThroughPagingIterator.oneShot();
        } else {
            Comparator<Row> rowOrdering = OrderingByPosition.rowOrdering(inputTypes, orderBy);
            pagingIterator = new RamAccountingPageIterator<TKey>(PagingIterator.createSorted(rowOrdering, requiresRepeat), rowAccountingSupplier.get());
        }
        return pagingIterator;
    }

    public static <TKey, TRow> PagingIterator<TKey, TRow> createSorted(Comparator<? super TRow> comparator, boolean requiresRepeat) {
        if (requiresRepeat) {
            return new RecordingSortedMergeIterator(comparator);
        }
        return new PlainSortedMergeIterator(comparator);
    }
}

