/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.export;

import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.export.FileOutputFactory;
import io.crate.execution.engine.export.FileWriterCountCollector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collector;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class FileWriterProjector
implements Projector {
    private final String uri;
    private final Iterable<CollectExpression<Row, ?>> collectExpressions;
    private final List<Input<?>> inputs;
    @Nullable
    private final List<String> outputNames;
    private final WriterProjection.OutputFormat outputFormat;
    private final WriterProjection.CompressionType compressionType;
    private final Executor executor;
    private final Map<String, FileOutputFactory> fileOutputFactoryMap;
    private final Settings withClauseOptions;

    public FileWriterProjector(Executor executor, String uri, @Nullable WriterProjection.CompressionType compressionType, @Nullable List<Input<?>> inputs, Iterable<CollectExpression<Row, ?>> collectExpressions, @Nullable List<String> outputNames, WriterProjection.OutputFormat outputFormat, Map<String, FileOutputFactory> fileOutputFactoryMap, Settings withClauseOptions) {
        this.collectExpressions = collectExpressions;
        this.executor = executor;
        this.inputs = inputs;
        this.outputNames = outputNames;
        this.outputFormat = outputFormat;
        this.compressionType = compressionType;
        this.uri = uri;
        this.fileOutputFactoryMap = fileOutputFactoryMap;
        this.withClauseOptions = withClauseOptions;
    }

    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, (Collector)new FileWriterCountCollector(this.executor, this.uri, this.compressionType, this.inputs, this.collectExpressions, this.outputNames, this.outputFormat, this.fileOutputFactoryMap, this.withClauseOptions));
    }

    public boolean providesIndependentScroll() {
        return false;
    }
}

