/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import io.crate.breaker.CellsSizeEstimator;
import io.crate.data.AsyncFlatMapBatchIterator;
import io.crate.data.AsyncFlatMapper;
import io.crate.data.BatchIterator;
import io.crate.data.BatchIterators;
import io.crate.data.Projector;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dsl.projection.FetchProjection;
import io.crate.execution.engine.fetch.FetchMapper;
import io.crate.execution.engine.fetch.FetchOperation;
import io.crate.execution.engine.fetch.FetchRows;
import io.crate.execution.engine.fetch.ReaderBuckets;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import java.util.function.LongSupplier;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.unit.ByteSizeUnit;

public final class FetchProjector {
    private static final long MIN_BYTES_PER_BUCKETS = ByteSizeUnit.KB.toBytes(64L);
    private static final double BREAKER_LIMIT_PERCENTAGE = 0.2;

    public static long computeReaderBucketsByteThreshold(CircuitBreaker circuitBreaker) {
        return Math.max((long)((double)circuitBreaker.getFree() * 0.2), MIN_BYTES_PER_BUCKETS);
    }

    public static Projector create(FetchProjection projection, RamAccounting ramAccounting, LongSupplier getBucketsBytesThreshold, TransactionContext txnCtx, NodeContext nodeCtx, FetchOperation fetchOperation) {
        FetchRows fetchRows = FetchRows.create(txnCtx, nodeCtx, projection.fetchSources(), projection.outputSymbols());
        CellsSizeEstimator estimateRowSize = CellsSizeEstimator.forColumns(projection.inputTypes());
        return source -> {
            long maxBucketsSizeInBytes = getBucketsBytesThreshold.getAsLong();
            BatchIterator buckets = BatchIterators.chunks((BatchIterator)source, (int)projection.getFetchSize(), () -> new ReaderBuckets(fetchRows, projection::getFetchSourceByReader, estimateRowSize, ramAccounting), ReaderBuckets::add, readerBuckets -> readerBuckets.ramBytesUsed() > maxBucketsSizeInBytes);
            return new AsyncFlatMapBatchIterator(buckets, (AsyncFlatMapper)new FetchMapper(fetchOperation, projection.nodeReaders()));
        };
    }
}

