/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.fetch;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import io.crate.common.annotations.GuardedBy;
import io.crate.common.collections.BorrowedItem;
import io.crate.common.collections.RefCountedItem;
import io.crate.common.exceptions.Exceptions;
import io.crate.execution.dsl.phases.FetchPhase;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.execution.jobs.SharedShardContexts;
import io.crate.execution.jobs.Task;
import io.crate.metadata.IndexName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.NotNull;

public class FetchTask
implements Task {
    private final IntObjectHashMap<RefCountedItem<? extends IndexSearcher>> searchers = new IntObjectHashMap();
    private final IntObjectHashMap<SharedShardContext> shardContexts = new IntObjectHashMap();
    private final FetchPhase phase;
    private final int memoryLimitInBytes;
    private final String localNodeId;
    private final SharedShardContexts sharedShardContexts;
    private final TreeMap<Integer, RelationName> tableIdents = new TreeMap();
    private final Metadata metadata;
    private final List<? extends Routing> routings;
    private final Map<RelationName, Collection<Reference>> toFetch;
    private final UUID jobId;
    private final Function<RelationName, DocTableInfo> getTableInfo;
    private final CompletableFuture<Void> result = new CompletableFuture();
    @GuardedBy(value="jobId")
    private int borrowed = 0;
    @GuardedBy(value="jobId")
    private Throwable killed;

    public FetchTask(UUID jobId, FetchPhase phase, int memoryLimitInBytes, String localNodeId, SharedShardContexts sharedShardContexts, Metadata metadata, Function<RelationName, DocTableInfo> getTableInfo, List<? extends Routing> routings) {
        this.jobId = jobId;
        this.phase = phase;
        this.memoryLimitInBytes = memoryLimitInBytes;
        this.localNodeId = localNodeId;
        this.sharedShardContexts = sharedShardContexts;
        this.metadata = metadata;
        this.routings = routings;
        this.toFetch = HashMap.newHashMap(phase.tableIndices().size());
        this.getTableInfo = getTableInfo;
        this.result.whenComplete((void_, throwable) -> {
            UUID uUID = jobId;
            synchronized (uUID) {
                for (IntObjectCursor cursor : this.searchers) {
                    ((RefCountedItem)cursor.value).close();
                }
                this.searchers.clear();
            }
        });
    }

    public int memoryLimitInBytes() {
        return this.memoryLimitInBytes;
    }

    public Map<RelationName, Collection<Reference>> toFetch() {
        return this.toFetch;
    }

    @Override
    public String name() {
        return this.phase.name();
    }

    @Override
    public long bytesUsed() {
        return -1L;
    }

    @NotNull
    public RelationName tableIdent(int readerId) {
        Map.Entry<Integer, RelationName> entry = this.tableIdents.floorEntry(readerId);
        if (entry == null) {
            throw new IllegalArgumentException("No table has been registered for readerId=" + readerId);
        }
        return entry.getValue();
    }

    @NotNull
    public DocTableInfo table(int readerId) {
        RelationName relationName = this.tableIdent(readerId);
        DocTableInfo table = this.getTableInfo.apply(relationName);
        if (table == null) {
            throw new IllegalStateException("TableInfo missing for relation " + String.valueOf(relationName));
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public BorrowedItem<IndexSearcher> searcher(int readerId) {
        UUID uUID = this.jobId;
        synchronized (uUID) {
            if (this.killed != null) {
                throw Exceptions.toRuntimeException((Throwable)this.killed);
            }
            RefCountedItem searcher = (RefCountedItem)this.searchers.get(readerId);
            if (searcher == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Searcher for reader with id %d not found", readerId));
            }
            ++this.borrowed;
            return new BorrowedItem((Object)((IndexSearcher)searcher.item()), () -> {
                UUID uUID = this.jobId;
                synchronized (uUID) {
                    --this.borrowed;
                    if (this.borrowed == 0 && this.killed != null) {
                        this.result.completeExceptionally(this.killed);
                    }
                }
            });
        }
    }

    @NotNull
    public IndexService indexService(int readerId) {
        SharedShardContext sharedShardContext = (SharedShardContext)this.shardContexts.get(readerId);
        if (sharedShardContext == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Reader with id %d not found", readerId));
        }
        return sharedShardContext.indexService();
    }

    public IndexShard indexShard(int readerId) {
        SharedShardContext sharedShardContext = (SharedShardContext)this.shardContexts.get(readerId);
        if (sharedShardContext == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Reader with id %d not found", readerId));
        }
        return sharedShardContext.indexShard();
    }

    public String toString() {
        return "FetchTask{phase=" + this.phase.phaseId() + ", borrowed=" + this.borrowed + ", done=" + this.result.isDone() + ", killed=" + String.valueOf(this.killed) + ", searchers=" + String.valueOf(this.searchers.keys()) + "}";
    }

    @Override
    public CompletableFuture<Void> completionFuture() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill(Throwable throwable) {
        UUID uUID = this.jobId;
        synchronized (uUID) {
            this.killed = throwable;
            if (this.borrowed == 0) {
                this.result.completeExceptionally(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        UUID uUID = this.jobId;
        synchronized (uUID) {
            assert (this.borrowed == 0) : "Close shouldn't be called while searchers are in use";
            if (this.killed == null) {
                this.result.complete(null);
            } else {
                this.result.completeExceptionally(this.killed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> start() {
        UUID uUID = this.jobId;
        synchronized (uUID) {
            if (this.killed != null) {
                this.result.completeExceptionally(this.killed);
                return null;
            }
            ArrayList<CompletableFuture<Void>> refreshActions = new ArrayList<CompletableFuture<Void>>(this.routings.size());
            for (Routing routing : this.routings) {
                Map<String, Map<String, IntIndexedContainer>> locations = routing.locations();
                Map<String, IntIndexedContainer> indexShards = locations.get(this.localNodeId);
                try {
                    refreshActions.add(this.sharedShardContexts.maybeRefreshReaders(this.metadata, indexShards, this.phase.bases()));
                }
                catch (Throwable t) {
                    this.result.completeExceptionally(t);
                    throw t;
                }
            }
            CompletableFuture<Void> allRefreshed = CompletableFuture.allOf((CompletableFuture[])refreshActions.toArray(CompletableFuture[]::new));
            return allRefreshed.thenApply(void_ -> {
                UUID uUID = this.jobId;
                synchronized (uUID) {
                    if (this.killed == null) {
                        this.setupSearchers();
                    }
                }
                return null;
            });
        }
    }

    private void setupSearchers() {
        HashMap<String, RelationName> index2TableIdent = new HashMap<String, RelationName>();
        for (Map.Entry<RelationName, Collection<String>> entry : this.phase.tableIndices().entrySet()) {
            for (String string : entry.getValue()) {
                index2TableIdent.put(string, entry.getKey());
            }
        }
        HashSet<RelationName> tablesWithFetchRefs = new HashSet<RelationName>();
        for (Reference reference : this.phase.fetchRefs()) {
            tablesWithFetchRefs.add(reference.ident().tableIdent());
        }
        String string = "fetch-task: " + this.jobId.toString() + "-" + this.phase.phaseId() + "-" + this.phase.name();
        for (Routing routing : this.routings) {
            Map<String, Map<String, IntIndexedContainer>> locations = routing.locations();
            Map<String, IntIndexedContainer> indexShards = locations.get(this.localNodeId);
            for (Map.Entry<String, IntIndexedContainer> indexShardsEntry : indexShards.entrySet()) {
                String indexName = indexShardsEntry.getKey();
                Integer base = this.phase.bases().get(indexName);
                if (base == null) continue;
                IndexMetadata indexMetadata = this.metadata.index(indexName);
                if (indexMetadata == null) {
                    if (IndexName.isPartitioned(indexName)) continue;
                    throw new IndexNotFoundException(indexName);
                }
                Index index = indexMetadata.getIndex();
                RelationName ident = (RelationName)index2TableIdent.get(indexName);
                assert (ident != null) : "no relationName found for index " + indexName;
                this.tableIdents.put(base, ident);
                this.toFetch.put(ident, new ArrayList());
                for (IntCursor shard : indexShardsEntry.getValue()) {
                    ShardId shardId = new ShardId(index, shard.value);
                    int readerId = base + shardId.id();
                    SharedShardContext shardContext = (SharedShardContext)this.shardContexts.get(readerId);
                    if (shardContext != null) continue;
                    try {
                        shardContext = this.sharedShardContexts.prepareContext(shardId, readerId);
                        this.shardContexts.put(readerId, (Object)shardContext);
                        if (!tablesWithFetchRefs.contains(ident)) continue;
                        this.searchers.put(readerId, shardContext.acquireSearcher(string));
                    }
                    catch (IndexNotFoundException | IllegalIndexShardStateException e) {
                        if (IndexName.isPartitioned(indexName)) continue;
                        throw e;
                    }
                }
            }
        }
        for (Reference reference : this.phase.fetchRefs()) {
            Collection<Reference> references = this.toFetch.get(reference.ident().tableIdent());
            if (references == null) continue;
            references.add(reference);
        }
        if (this.searchers.isEmpty() || this.phase.fetchRefs().isEmpty()) {
            this.close();
        }
    }

    @Override
    public int id() {
        return this.phase.phaseId();
    }

    public UUID jobId() {
        return this.jobId;
    }
}

