/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.common.collections.Maps;
import io.crate.data.BatchIterator;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.ItemFactory;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.execution.engine.indexing.UpsertResults;
import io.crate.execution.jobs.NodeLimits;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.Nullable;

public class IndexWriterProjector
implements Projector {
    private final ShardingUpsertExecutor shardingUpsertExecutor;

    public IndexWriterProjector(ClusterService clusterService, NodeLimits nodeJobsCounter, CircuitBreaker queryCircuitBreaker, RamAccounting ramAccounting, ScheduledExecutorService scheduler, Executor executor, TransactionContext txnCtx, NodeContext nodeCtx, Settings settings, int targetTableNumShards, int targetTableNumReplicas, Client elasticsearchClient, Supplier<String> indexNameResolver, Reference rawSourceReference, List<ColumnIdent> primaryKeyIdents, List<? extends Symbol> primaryKeySymbols, @Nullable Symbol routingSymbol, ColumnIdent clusteredByColumn, Input<?> sourceInput, List<? extends CollectExpression<Row, ?>> collectExpressions, int bulkActions, @Nullable String[] excludes, boolean autoCreateIndices, boolean overwriteDuplicates, UUID jobId, UpsertResultContext upsertResultContext, boolean failFast) {
        MapInput source = excludes == null ? sourceInput : new MapInput(sourceInput, excludes);
        RowShardResolver rowShardResolver = new RowShardResolver(txnCtx, nodeCtx, primaryKeyIdents, primaryKeySymbols, clusteredByColumn, routingSymbol);
        Reference[] missingAssignmentsColumns = new Reference[]{rawSourceReference};
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(txnCtx.sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.get(settings), overwriteDuplicates ? ShardUpsertRequest.DuplicateKeyAction.OVERWRITE : ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, true, null, missingAssignmentsColumns, null, jobId);
        ItemFactory<ShardUpsertRequest.Item> itemFactory = (id, pkValues, autoGeneratedTimestamp) -> ShardUpsertRequest.Item.forInsert(id, pkValues, autoGeneratedTimestamp, missingAssignmentsColumns, new Object[]{source.value()}, null, 0L);
        Predicate<UpsertResults> earlyTerminationCondition = results -> failFast && results.containsErrors();
        Function<UpsertResults, Throwable> earlyTerminationExceptionGenerator = UpsertResults::resultsToFailure;
        this.shardingUpsertExecutor = new ShardingUpsertExecutor(clusterService, (ignored1, ignored2) -> {}, nodeJobsCounter, queryCircuitBreaker, ramAccounting, scheduler, executor, bulkActions, jobId, rowShardResolver, itemFactory, builder::newRequest, collectExpressions, indexNameResolver, autoCreateIndices, elasticsearchClient, targetTableNumShards, targetTableNumReplicas, upsertResultContext, earlyTerminationCondition, earlyTerminationExceptionGenerator);
    }

    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return CollectingBatchIterator.newInstance(batchIterator, (Function)this.shardingUpsertExecutor, (boolean)batchIterator.hasLazyResultSet());
    }

    public boolean providesIndependentScroll() {
        return false;
    }

    private static class MapInput
    implements Input<String> {
        private final Input<Map<String, Object>> sourceInput;
        private final String[] excludes;
        private static final Logger LOGGER = LogManager.getLogger(MapInput.class);
        private int lastSourceSize;

        private MapInput(Input<Map<String, Object>> sourceInput, String[] excludes) {
            this.sourceInput = sourceInput;
            this.excludes = excludes;
            this.lastSourceSize = 16384;
        }

        public String value() {
            String string;
            Map value = (Map)this.sourceInput.value();
            if (value == null) {
                return null;
            }
            assert (value instanceof LinkedHashMap) : "the raw source order should be preserved";
            if (this.excludes != null) {
                for (String exclude : this.excludes) {
                    String[] path = exclude.split("\\.");
                    Maps.removeByPath((Map)value, Arrays.asList(path));
                }
            }
            XContentBuilder xContentBuilder = new XContentBuilder(XContentType.JSON.xContent(), (OutputStream)new BytesStreamOutput(this.lastSourceSize));
            try {
                BytesReference bytes = BytesReference.bytes(xContentBuilder.map(value));
                this.lastSourceSize = bytes.length();
                string = bytes.utf8ToString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        xContentBuilder.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LOGGER.error("could not parse xContent", (Throwable)ex);
                    return null;
                }
            }
            xContentBuilder.close();
            return string;
        }
    }
}

