/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.common.concurrent.ConcurrencyLimit;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.unit.ByteSizeUnit;

class IsUsedBytesOverThreshold
implements Predicate<Accountable> {
    private static final Logger LOGGER = LogManager.getLogger(IsUsedBytesOverThreshold.class);
    private static final long MIN_ACCEPTABLE_BYTES = ByteSizeUnit.KB.toBytes(64L);
    private final CircuitBreaker queryCircuitBreaker;
    private final ConcurrencyLimit nodeLimit;

    public IsUsedBytesOverThreshold(CircuitBreaker queryCircuitBreaker, ConcurrencyLimit nodeLimit) {
        this.queryCircuitBreaker = queryCircuitBreaker;
        this.nodeLimit = nodeLimit;
    }

    @Override
    public final boolean test(Accountable accountable) {
        boolean requestsTooBig;
        long localJobs = Math.max(1, this.nodeLimit.numInflight());
        double memoryRatio = 1.0 / (double)localJobs;
        long maxUsableByShardRequests = Math.max((long)((double)this.queryCircuitBreaker.getFree() * 0.5 * memoryRatio), MIN_ACCEPTABLE_BYTES);
        long usedMemoryEstimate = accountable.ramBytesUsed();
        boolean bl = requestsTooBig = usedMemoryEstimate > maxUsableByShardRequests;
        if (requestsTooBig && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating smaller bulk requests because shardedRequests is using too much memory. request={} maxBytesUsableByShardedRequests={}", (Object)accountable, (Object)maxUsableByShardRequests);
        }
        return requestsTooBig;
    }
}

