/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.join;

import com.carrotsearch.hppc.IntArrayList;
import io.crate.data.BatchIterator;
import io.crate.data.Paging;
import io.crate.data.Row;
import io.crate.data.UnsafeArrayRow;
import io.crate.data.breaker.RowAccounting;
import io.crate.data.join.CombinedRow;
import io.crate.data.join.ElementCombiner;
import io.crate.data.join.JoinBatchIterator;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import java.util.function.LongToIntFunction;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.elasticsearch.common.breaker.CircuitBreaker;

public class HashJoinBatchIterator
extends JoinBatchIterator<Row, Row, Row> {
    private final RowAccounting<Object[]> leftRowAccounting;
    private final Predicate<Row> joinCondition;
    private final UnsafeArrayRow leftRow = new UnsafeArrayRow();
    private final CircuitBreaker circuitBreaker;
    private final ToIntFunction<Row> hashBuilderForLeft;
    private final ToIntFunction<Row> hashBuilderForRight;
    private final LongToIntFunction calculateBlockSize;
    private final IntObjectHashMap<Values> buffer;
    private final boolean emitNullValues;
    private final UnsafeArrayRow unsafeArrayRow = new UnsafeArrayRow();
    private int leftAverageRowSize = -1;
    private int blockSize;
    private int numberOfRowsInBuffer = 0;
    private boolean leftBatchHasItems = false;
    private int numberOfLeftBatchesForBlock;
    private int numberOfLeftBatchesLoadedForBlock;
    private Iterator<Object[]> leftMatchingRowsIterator;
    private IntArrayList nonMatchingKeys;
    private int nonMatchingKeysIdx = 0;
    private Iterator<Object[]> nonMatchValuesIterator;
    private Values leftMatchingRows;
    private boolean blockFull = false;

    public HashJoinBatchIterator(CircuitBreaker circuitBreaker, BatchIterator<Row> left, BatchIterator<Row> right, RowAccounting<Object[]> leftRowAccounting, CombinedRow combiner, Predicate<Row> joinCondition, ToIntFunction<Row> hashBuilderForLeft, ToIntFunction<Row> hashBuilderForRight, LongToIntFunction calculateBlockSize, boolean emitNullValues) {
        super(left, right, (ElementCombiner)combiner);
        this.circuitBreaker = circuitBreaker;
        this.leftRowAccounting = leftRowAccounting;
        this.joinCondition = joinCondition;
        this.hashBuilderForLeft = hashBuilderForLeft;
        this.hashBuilderForRight = hashBuilderForRight;
        this.calculateBlockSize = calculateBlockSize;
        this.buffer = new IntObjectHashMap();
        this.resetBuffer();
        this.numberOfLeftBatchesLoadedForBlock = 0;
        this.activeIt = left;
        this.emitNullValues = emitNullValues;
    }

    public Row currentElement() {
        return (Row)this.combiner.currentElement();
    }

    public void moveToStart() {
        this.left.moveToStart();
        this.right.moveToStart();
        this.activeIt = this.left;
        this.resetBuffer();
        this.leftMatchingRowsIterator = null;
        this.nonMatchingKeys = null;
        this.nonMatchingKeysIdx = 0;
        this.nonMatchValuesIterator = null;
        this.leftMatchingRows = null;
        this.blockFull = false;
    }

    public CompletionStage<?> loadNextBatch() throws Exception {
        if (this.activeIt == this.left) {
            ++this.numberOfLeftBatchesLoadedForBlock;
        }
        return super.loadNextBatch();
    }

    public boolean moveNext() {
        while (!this.buildBufferAndMatchRight()) {
            if (this.right.allLoaded() && !this.leftBatchHasItems && this.left.allLoaded()) {
                if (this.emitNullValues) {
                    this.extractNonMatchingKeys();
                    if (this.hasMoreNonMatchingKeys()) {
                        return this.emitNullValuesPairs();
                    }
                }
                return false;
            }
            if (this.activeIt == this.left) {
                return false;
            }
            if (this.right.allLoaded()) {
                if (this.emitNullValues) {
                    this.extractNonMatchingKeys();
                    if (this.hasMoreNonMatchingKeys()) {
                        return this.emitNullValuesPairs();
                    }
                }
                this.right.moveToStart();
                this.activeIt = this.left;
                this.resetBuffer();
                this.nonMatchingKeys = null;
                this.nonMatchingKeysIdx = 0;
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean hasMoreNonMatchingKeys() {
        return this.nonMatchingKeysIdx < this.nonMatchingKeys.size();
    }

    private void extractNonMatchingKeys() {
        if (this.nonMatchingKeys == null) {
            this.nonMatchingKeys = new IntArrayList();
            for (IntObjectMap.PrimitiveEntry values : this.buffer.entries()) {
                if (((Values)values.value()).matched) continue;
                this.nonMatchingKeys.add(values.key());
            }
        }
    }

    private boolean emitNullValuesPairs() {
        if (this.nonMatchValuesIterator == null) {
            int key = this.nonMatchingKeys.get(this.nonMatchingKeysIdx);
            this.nonMatchValuesIterator = ((Values)this.buffer.get((int)key)).items.iterator();
        }
        this.combiner.setLeft((Object)this.unsafeArrayRow.cells(this.nonMatchValuesIterator.next()));
        this.combiner.nullRight();
        if (!this.nonMatchValuesIterator.hasNext()) {
            ++this.nonMatchingKeysIdx;
            this.nonMatchValuesIterator = null;
        }
        return true;
    }

    private void resetBuffer() {
        this.blockSize = this.calculateBlockSize.applyAsInt(this.leftAverageRowSize);
        this.buffer.clear();
        this.numberOfRowsInBuffer = 0;
        this.leftRowAccounting.release();
        this.blockFull = false;
        this.numberOfLeftBatchesForBlock = Math.max(1, (int)Math.ceil((double)this.blockSize / (double)Paging.PAGE_SIZE));
        this.numberOfLeftBatchesLoadedForBlock = this.leftBatchHasItems ? 1 : 0;
    }

    private boolean buildBufferAndMatchRight() {
        if (this.activeIt == this.left) {
            long numItems = 0L;
            long sum = 0L;
            while (this.leftBatchHasItems = this.left.moveNext()) {
                Object[] leftRow = ((Row)this.left.currentElement()).materialize();
                long leftRowSize = this.leftRowAccounting.accountForAndMaybeBreak((Object)leftRow);
                sum += leftRowSize;
                ++numItems;
                int hash = this.hashBuilderForLeft.applyAsInt((Row)this.unsafeArrayRow.cells(leftRow));
                this.addToBuffer(leftRow, hash);
                if (this.numberOfRowsInBuffer != this.blockSize && this.circuitBreaker.getFree() >= 524288L) continue;
                this.blockFull = true;
                break;
            }
            int n = this.leftAverageRowSize = numItems > 0L ? (int)(sum / numItems) : -1;
            if (this.mustLoadLeftNextBatch()) {
                return false;
            }
            if (this.mustSwitchToRight()) {
                this.activeIt = this.right;
            }
        }
        if (this.leftMatchingRowsIterator != null && this.findMatchingRows()) {
            if (this.emitNullValues && !this.leftMatchingRows.matched) {
                this.leftMatchingRows.matched = true;
            }
            return true;
        }
        this.leftMatchingRowsIterator = null;
        while (this.right.moveNext()) {
            int rightHash = this.hashBuilderForRight.applyAsInt((Row)this.right.currentElement());
            this.leftMatchingRows = (Values)this.buffer.get(rightHash);
            if (this.leftMatchingRows == null) continue;
            this.leftMatchingRowsIterator = this.leftMatchingRows.items.iterator();
            this.combiner.setRight((Object)((Row)this.right.currentElement()));
            if (!this.findMatchingRows()) continue;
            if (this.emitNullValues && !this.leftMatchingRows.matched) {
                this.leftMatchingRows.matched = true;
            }
            return true;
        }
        return false;
    }

    private void addToBuffer(Object[] currentRow, int hash) {
        Values existingRows = (Values)this.buffer.get(hash);
        if (existingRows == null) {
            existingRows = new Values();
            this.buffer.put(hash, (Object)existingRows);
        }
        existingRows.items.add(currentRow);
        ++this.numberOfRowsInBuffer;
    }

    private boolean findMatchingRows() {
        while (this.leftMatchingRowsIterator.hasNext()) {
            this.leftRow.cells(this.leftMatchingRowsIterator.next());
            this.combiner.setLeft((Object)this.leftRow);
            if (!this.joinCondition.test((Row)this.combiner.currentElement())) continue;
            return true;
        }
        return false;
    }

    private boolean mustSwitchToRight() {
        return this.left.allLoaded() || this.blockFull || !this.leftBatchHasItems && this.numberOfLeftBatchesLoadedForBlock == this.numberOfLeftBatchesForBlock;
    }

    private boolean mustLoadLeftNextBatch() {
        return !this.leftBatchHasItems && !this.left.allLoaded() && !this.blockFull && this.numberOfLeftBatchesLoadedForBlock < this.numberOfLeftBatchesForBlock;
    }

    private static final class Values {
        ArrayList<Object[]> items = new ArrayList();
        boolean matched = false;

        private Values() {
        }
    }
}

