/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.expression.InputRow;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;

public final class MapRowUsingInputs
implements UnaryOperator<Row> {
    private final List<? extends CollectExpression<Row, ?>> expressions;
    private final Row resultRow;

    public MapRowUsingInputs(List<? extends Input<?>> inputs, List<? extends CollectExpression<Row, ?>> expressions) {
        assert (expressions instanceof RandomAccess) : "Must be able to use fast indexed for loop to avoid iterator allocations";
        this.expressions = expressions;
        this.resultRow = new InputRow(inputs);
    }

    @Override
    public Row apply(Row row) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            this.expressions.get(i).setNextRow(row);
        }
        return this.resultRow;
    }
}

