/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.pipeline;

import io.crate.data.BatchIterator;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.SkippingBatchIterator;

public class OffsetProjector
implements Projector {
    private final int offset;

    public OffsetProjector(int offset) {
        if (offset <= 0) {
            throw new IllegalArgumentException("Invalid OFFSET: value must be > 0; got: " + offset);
        }
        this.offset = offset;
    }

    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        return new SkippingBatchIterator(batchIterator, this.offset);
    }

    public boolean providesIndependentScroll() {
        return false;
    }
}

