/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.profile;

import io.crate.execution.engine.profile.CollectProfileRequest;
import io.crate.execution.engine.profile.NodeCollectProfileResponse;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.TasksService;
import io.crate.execution.support.NodeActionRequestHandler;
import io.crate.execution.support.NodeRequest;
import io.crate.execution.support.Transports;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportCollectProfileNodeAction
extends TransportAction<NodeRequest<CollectProfileRequest>, NodeCollectProfileResponse> {
    private final Transports transports;
    private final TasksService tasksService;

    @Inject
    public TransportCollectProfileNodeAction(TransportService transportService, Transports transports, TasksService tasksService) {
        super("internal:crate:sql/node/profile/collect");
        this.transports = transports;
        this.tasksService = tasksService;
        transportService.registerRequestHandler("internal:crate:sql/node/profile/collect", "search", true, false, CollectProfileRequest::new, new NodeActionRequestHandler(this::nodeOperation));
    }

    private CompletableFuture<NodeCollectProfileResponse> nodeOperation(CollectProfileRequest request) {
        return this.collectExecutionTimesAndFinishContext(request.jobId()).thenApply(NodeCollectProfileResponse::new);
    }

    public CompletableFuture<Map<String, Object>> collectExecutionTimesAndFinishContext(UUID jobId) {
        RootTask rootTask = this.tasksService.getTaskOrNull(jobId);
        if (rootTask == null) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return rootTask.finishProfiling();
    }

    @Override
    public void doExecute(NodeRequest<CollectProfileRequest> request, ActionListener<NodeCollectProfileResponse> listener) {
        this.transports.sendRequest("internal:crate:sql/node/profile/collect", request.nodeId(), request.innerRequest(), listener, new ActionListenerResponseHandler<NodeCollectProfileResponse>("internal:crate:sql/node/profile/collect", listener, NodeCollectProfileResponse::new));
    }
}

