/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.profile;

import io.crate.execution.engine.profile.CollectProfileOperation;
import io.crate.execution.engine.profile.CollectProfileRequest;
import io.crate.execution.engine.profile.NodeCollectProfileResponse;
import io.crate.execution.support.ActionExecutor;
import io.crate.execution.support.NodeRequest;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class TransportCollectProfileOperation
implements CollectProfileOperation {
    private final UUID jobId;
    private final ActionExecutor<NodeRequest<CollectProfileRequest>, NodeCollectProfileResponse> transportAction;

    public TransportCollectProfileOperation(ActionExecutor<NodeRequest<CollectProfileRequest>, NodeCollectProfileResponse> transportAction, UUID jobId) {
        this.jobId = jobId;
        this.transportAction = transportAction;
    }

    @Override
    public CompletableFuture<Map<String, Object>> collect(String nodeId) {
        return this.transportAction.execute(CollectProfileRequest.of(nodeId, this.jobId)).thenApply(NodeCollectProfileResponse::durationByContextIdent);
    }
}

