/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.types.DataType;
import java.util.Comparator;
import java.util.function.Function;

class NullAwareComparator<T, U>
implements Comparator<T> {
    private final int mod;
    private final Function<T, U> keyExtractor;
    private final int leftNull;
    private final int rightNull;
    private final DataType<U> type;

    NullAwareComparator(Function<T, U> keyExtractor, DataType<U> type, boolean reverse, boolean nullsFirst) {
        this.type = type;
        this.keyExtractor = keyExtractor;
        this.mod = reverse ? -1 : 1;
        this.leftNull = nullsFirst ? -1 : 1;
        this.rightNull = nullsFirst ? 1 : -1;
    }

    @Override
    public int compare(T o1, T o2) {
        U val2;
        U val1 = this.keyExtractor.apply(o1);
        if (val1 == (val2 = this.keyExtractor.apply(o2))) {
            return 0;
        }
        if (val1 == null) {
            return this.leftNull;
        }
        if (val2 == null) {
            return this.rightNull;
        }
        return this.type.compare(val1, val2) * this.mod;
    }
}

