/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.data.BatchIterator;
import io.crate.data.Bucket;
import io.crate.data.CollectingBatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Input;
import io.crate.data.Projector;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.data.breaker.RowAccounting;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.sort.BoundedSortingLimitAndOffsetCollector;
import io.crate.execution.engine.sort.UnboundedSortingLimitAndOffsetCollector;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collector;

public class SortingLimitAndOffsetProjector
implements Projector {
    private final Collector<Row, ?, Bucket> collector;
    private final boolean hasNoResult;

    public SortingLimitAndOffsetProjector(RowAccounting<Object[]> rowAccounting, Collection<? extends Input<?>> inputs, Iterable<? extends CollectExpression<Row, ?>> collectExpressions, int numOutputs, Comparator<Object[]> ordering, int limit, int offset, int unboundedCollectorThreshold) {
        boolean bl = this.hasNoResult = limit + offset == 0;
        if (offset < 0) {
            throw new IllegalArgumentException("Invalid OFFSET: value must be >= 0; got: " + offset);
        }
        this.collector = this.hasNoResult ? null : (limit + offset > unboundedCollectorThreshold ? new UnboundedSortingLimitAndOffsetCollector(rowAccounting, inputs, collectExpressions, numOutputs, ordering, unboundedCollectorThreshold, limit, offset) : new BoundedSortingLimitAndOffsetCollector(rowAccounting, inputs, collectExpressions, numOutputs, ordering, limit, offset));
    }

    public BatchIterator<Row> apply(BatchIterator<Row> batchIterator) {
        if (this.hasNoResult) {
            batchIterator.close();
            return InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL);
        }
        return CollectingBatchIterator.newInstance(batchIterator, this.collector);
    }

    public boolean providesIndependentScroll() {
        return true;
    }
}

