/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.breaker.BlockBasedRamAccounting;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.PKLookupOperation;
import io.crate.execution.jobs.AbstractTask;
import io.crate.expression.InputFactory;
import io.crate.expression.InputRow;
import io.crate.expression.reference.Doc;
import io.crate.expression.reference.DocRefResolver;
import io.crate.expression.symbol.Symbol;
import io.crate.memory.MemoryManager;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.operators.PKAndVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.elasticsearch.index.shard.ShardId;

public final class PKLookupTask
extends AbstractTask {
    private final UUID jobId;
    private final RamAccounting ramAccounting;
    private final TransactionContext txnCtx;
    private final PKLookupOperation pkLookupOperation;
    private final boolean ignoreMissing;
    private final Map<ShardId, SequencedSet<PKAndVersion>> idsByShard;
    private final Collection<? extends Projection> shardProjections;
    private final RowConsumer consumer;
    private final InputRow inputRow;
    private final List<CollectExpression<Doc, ?>> expressions;
    private final List<Symbol> toCollect;
    private final String name;
    private final Function<RamAccounting, MemoryManager> memoryManagerFactory;
    private final int ramAccountingBlockSizeInBytes;
    private final ArrayList<MemoryManager> memoryManagers = new ArrayList();
    private final Function<RelationName, DocTableInfo> getTableInfo;
    private long totalBytes = -1L;

    PKLookupTask(UUID jobId, int phaseId, String name, RamAccounting ramAccounting, Function<RamAccounting, MemoryManager> memoryManagerFactory, int ramAccountingBlockSizeInBytes, TransactionContext txnCtx, Schemas schemas, InputFactory inputFactory, PKLookupOperation pkLookupOperation, List<ColumnIdent> partitionedByColumns, List<Symbol> toCollect, Map<ShardId, SequencedSet<PKAndVersion>> idsByShard, Collection<? extends Projection> shardProjections, RowConsumer consumer) {
        super(phaseId);
        this.jobId = jobId;
        this.name = name;
        this.ramAccounting = ramAccounting;
        this.txnCtx = txnCtx;
        this.pkLookupOperation = pkLookupOperation;
        this.idsByShard = idsByShard;
        this.shardProjections = shardProjections;
        this.consumer = consumer;
        this.memoryManagerFactory = memoryManagerFactory;
        this.ramAccountingBlockSizeInBytes = ramAccountingBlockSizeInBytes;
        this.toCollect = toCollect;
        this.getTableInfo = schemas::getTableInfo;
        this.ignoreMissing = !partitionedByColumns.isEmpty();
        DocRefResolver docRefResolver = new DocRefResolver(partitionedByColumns);
        InputFactory.Context ctx = inputFactory.ctxForRefs(txnCtx, docRefResolver);
        ctx.add(toCollect);
        this.expressions = ctx.expressions();
        this.inputRow = new InputRow(ctx.topLevelInputs());
    }

    @Override
    protected CompletableFuture<Void> innerStart() {
        BatchIterator<Row> rowBatchIterator = this.pkLookupOperation.lookup(this.jobId, this.txnCtx, this::getRamAccounting, this::getMemoryManager, this.ignoreMissing, this.idsByShard, this.shardProjections, this.consumer.requiresScroll(), this::resultToRow, this.getTableInfo, this.toCollect);
        this.consumer.accept(rowBatchIterator, null);
        this.close();
        return null;
    }

    private Row resultToRow(Doc getResult) {
        for (int i = 0; i < this.expressions.size(); ++i) {
            this.expressions.get(i).setNextRow(getResult);
        }
        return this.inputRow;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerClose() {
        this.totalBytes = this.ramAccounting.totalBytes();
        ArrayList<MemoryManager> arrayList = this.memoryManagers;
        synchronized (arrayList) {
            for (MemoryManager memoryManager : this.memoryManagers) {
                memoryManager.close();
            }
            this.memoryManagers.clear();
        }
    }

    @Override
    public long bytesUsed() {
        if (this.totalBytes == -1L) {
            return this.ramAccounting.totalBytes();
        }
        return this.totalBytes;
    }

    public RamAccounting getRamAccounting() {
        return new BlockBasedRamAccounting(arg_0 -> ((RamAccounting)this.ramAccounting).addBytes(arg_0), this.ramAccountingBlockSizeInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryManager getMemoryManager() {
        MemoryManager memoryManager = this.memoryManagerFactory.apply(this.ramAccounting);
        ArrayList<MemoryManager> arrayList = this.memoryManagers;
        synchronized (arrayList) {
            this.memoryManagers.add(memoryManager);
        }
        return memoryManager;
    }
}

