/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs.transport;

import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.support.NodeRequest;
import io.crate.metadata.settings.SessionSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class JobRequest
extends TransportRequest {
    private final UUID jobId;
    private final SessionSettings sessionSettings;
    private final String coordinatorNodeId;
    private final Collection<? extends NodeOperation> nodeOperations;
    private final boolean enableProfiling;

    public static NodeRequest<JobRequest> of(String nodeId, UUID jobId, SessionSettings sessionSettings, String coordinatorNodeId, Collection<? extends NodeOperation> nodeOperations, boolean enableProfiling) {
        return new NodeRequest<JobRequest>(nodeId, new JobRequest(jobId, sessionSettings, coordinatorNodeId, nodeOperations, enableProfiling));
    }

    private JobRequest(UUID jobId, SessionSettings sessionSettings, String coordinatorNodeId, Collection<? extends NodeOperation> nodeOperations, boolean enableProfiling) {
        this.jobId = jobId;
        this.coordinatorNodeId = coordinatorNodeId;
        this.sessionSettings = sessionSettings;
        this.nodeOperations = nodeOperations;
        this.enableProfiling = enableProfiling;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public Collection<? extends NodeOperation> nodeOperations() {
        return this.nodeOperations;
    }

    public String coordinatorNodeId() {
        return this.coordinatorNodeId;
    }

    public boolean enableProfiling() {
        return this.enableProfiling;
    }

    public SessionSettings sessionSettings() {
        return this.sessionSettings;
    }

    JobRequest(StreamInput in) throws IOException {
        super(in);
        this.jobId = new UUID(in.readLong(), in.readLong());
        this.coordinatorNodeId = in.readString();
        int numNodeOperations = in.readVInt();
        ArrayList<? extends NodeOperation> nodeOperations = new ArrayList<NodeOperation>(numNodeOperations);
        for (int i = 0; i < numNodeOperations; ++i) {
            nodeOperations.add(new NodeOperation(in));
        }
        this.nodeOperations = nodeOperations;
        this.enableProfiling = in.readBoolean();
        this.sessionSettings = new SessionSettings(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.jobId.getMostSignificantBits());
        out.writeLong(this.jobId.getLeastSignificantBits());
        out.writeString(this.coordinatorNodeId);
        out.writeVInt(this.nodeOperations.size());
        for (NodeOperation nodeOperation : this.nodeOperations) {
            nodeOperation.writeTo(out);
        }
        out.writeBoolean(this.enableProfiling);
        this.sessionSettings.writeTo(out);
    }
}

