/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.common.exceptions.Exceptions;
import io.crate.execution.support.NodeAction;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;

public final class NodeActionRequestHandler<TRequest extends TransportRequest, TResponse extends TransportResponse>
implements TransportRequestHandler<TRequest> {
    private final NodeAction<TRequest, TResponse> nodeAction;
    private static final Logger LOGGER = LogManager.getLogger(NodeActionRequestHandler.class);

    public NodeActionRequestHandler(NodeAction<TRequest, TResponse> nodeAction) {
        this.nodeAction = nodeAction;
    }

    @Override
    public void messageReceived(TRequest request, TransportChannel channel) throws Exception {
        try {
            this.nodeAction.nodeOperation(request).whenComplete((result, throwable) -> {
                if (throwable == null) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error sending response: " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    try {
                        channel.sendResponse(Exceptions.toException((Throwable)throwable));
                    }
                    catch (IOException e) {
                        LOGGER.error("Error sending failure: " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        catch (Throwable t) {
            try {
                channel.sendResponse(Exceptions.toException((Throwable)t));
            }
            catch (IOException e) {
                LOGGER.error("Error sending failure: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

