/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.support;

import io.crate.common.collections.Iterables;
import io.crate.common.collections.Lists;
import io.crate.common.concurrent.CompletableFutures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class ThreadPools {
    public static IntSupplier numIdleThreads(ThreadPoolExecutor executor, int numProcessors) {
        return () -> Math.min(Math.max(executor.getMaximumPoolSize() - executor.getActiveCount(), 1), numProcessors);
    }

    public static <T> CompletableFuture<List<T>> runWithAvailableThreads(Executor executor, IntSupplier availableThreads, Collection<Supplier<T>> suppliers) throws RejectedExecutionException {
        int threadsToUse = availableThreads.getAsInt();
        if (threadsToUse < suppliers.size()) {
            Iterable partitions = Iterables.partition(suppliers, (int)(suppliers.size() / threadsToUse));
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(threadsToUse + 1);
            for (List partition : partitions) {
                Supplier<List> executePartition = () -> Lists.map((Collection)partition, Supplier::get);
                futures.add(CompletableFutures.supplyAsync(executePartition, (Executor)executor));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(aVoid -> {
                ArrayList finalResult = new ArrayList(suppliers.size());
                for (CompletableFuture future : futures) {
                    finalResult.addAll((Collection)future.join());
                }
                return finalResult;
            });
        }
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(suppliers.size());
        for (Supplier<T> supplier : suppliers) {
            futures.add(CompletableFutures.supplyAsync(supplier, (Executor)executor));
        }
        return CompletableFutures.allAsList(futures);
    }

    public static void forceExecute(Executor executor, Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            runnable.run();
        }
    }
}

